/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.util.Context;
import org.nutz.mvc.ActionHandler;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.SessionProvider;
import org.nutz.mvc.config.ServletNutConfig;

public class NutServlet
extends HttpServlet {
    protected ActionHandler handler;
    private String selfName;
    private SessionProvider sp;

    public void init(ServletConfig servletConfig) throws ServletException {
        Mvcs.setServletContext(servletConfig.getServletContext());
        this.selfName = servletConfig.getServletName();
        Mvcs.set(this.selfName, null, null);
        ServletNutConfig config = new ServletNutConfig(servletConfig);
        Mvcs.setNutConfig(config);
        this.handler = new ActionHandler(config);
        this.sp = config.getSessionProvider();
    }

    public void destroy() {
        Mvcs.resetALL();
        Mvcs.set(this.selfName, null, null);
        if (this.handler != null) {
            this.handler.depose();
        }
        Mvcs.setServletContext(null);
        Mvcs.close();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String preName = Mvcs.getName();
        Context preContext = Mvcs.resetALL();
        try {
            if (this.sp != null) {
                req = this.sp.filter(req, resp, this.getServletContext());
            }
            Mvcs.set(this.selfName, req, resp);
            if (!this.handler.handle(req, resp)) {
                resp.sendError(404);
            }
        }
        finally {
            Mvcs.resetALL();
            if (req.getAttribute("javax.servlet.forward.request_uri") != null) {
                if (preName != null) {
                    Mvcs.set(preName, req, resp);
                }
                if (preContext != null) {
                    Mvcs.ctx.reqThreadLocal.set(preContext);
                }
            }
        }
    }
}

