/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor;

import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.ioc.Ioc;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.MethodParamNamesScaner;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.HttpAdaptor;
import org.nutz.mvc.Scope;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.adaptor.injector.AllAttrInjector;
import org.nutz.mvc.adaptor.injector.AppAttrInjector;
import org.nutz.mvc.adaptor.injector.HttpInputStreamInjector;
import org.nutz.mvc.adaptor.injector.HttpReaderInjector;
import org.nutz.mvc.adaptor.injector.IocInjector;
import org.nutz.mvc.adaptor.injector.IocObjInjector;
import org.nutz.mvc.adaptor.injector.NameInjector;
import org.nutz.mvc.adaptor.injector.PathArgInjector;
import org.nutz.mvc.adaptor.injector.ReqHeaderInjector;
import org.nutz.mvc.adaptor.injector.RequestAttrInjector;
import org.nutz.mvc.adaptor.injector.RequestInjector;
import org.nutz.mvc.adaptor.injector.ResponseInjector;
import org.nutz.mvc.adaptor.injector.ServletContextInjector;
import org.nutz.mvc.adaptor.injector.SessionAttrInjector;
import org.nutz.mvc.adaptor.injector.SessionInjector;
import org.nutz.mvc.annotation.Attr;
import org.nutz.mvc.annotation.IocObj;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.annotation.ReqHeader;
import org.nutz.mvc.impl.AdaptorErrorContext;

public abstract class AbstractAdaptor
implements HttpAdaptor {
    private static final Log log = Logs.get();
    protected ParamInjector[] injs;
    protected Method method;
    protected Class<?>[] argTypes;

    @Override
    public void init(Method method) {
        this.method = method;
        this.argTypes = method.getParameterTypes();
        this.injs = new ParamInjector[this.argTypes.length];
        Annotation[][] annss = method.getParameterAnnotations();
        Type[] types = method.getGenericParameterTypes();
        int i = 0;
        while (i < annss.length) {
            Annotation[] anns = annss[i];
            Param param = null;
            Attr attr = null;
            IocObj iocObj = null;
            ReqHeader reqHeader = null;
            int x = 0;
            while (x < anns.length) {
                if (anns[x] instanceof Param) {
                    param = (Param)anns[x];
                    break;
                }
                if (anns[x] instanceof Attr) {
                    attr = (Attr)anns[x];
                    break;
                }
                if (anns[x] instanceof IocObj) {
                    iocObj = (IocObj)anns[x];
                    break;
                }
                if (anns[x] instanceof ReqHeader) {
                    reqHeader = (ReqHeader)anns[x];
                    break;
                }
                ++x;
            }
            if (attr != null) {
                this.injs[i] = AbstractAdaptor.evalInjectorByAttrScope(attr);
            } else if (iocObj != null) {
                this.injs[i] = new IocObjInjector(method.getParameterTypes()[i], iocObj.value());
            } else if (reqHeader != null) {
                this.injs[i] = new ReqHeaderInjector(reqHeader.value(), this.argTypes[i]);
            } else {
                this.injs[i] = AbstractAdaptor.evalInjectorByParamType(this.argTypes[i]);
                if (this.injs[i] == null) {
                    this.injs[i] = this.evalInjector(types[i], param);
                    if (this.injs[i] == null) {
                        this.injs[i] = this.paramNameInject(method, i);
                    }
                }
            }
            ++i;
        }
    }

    private static ParamInjector evalInjectorByAttrScope(Attr attr) {
        if (attr.scope() == Scope.APP) {
            return new AppAttrInjector(attr.value());
        }
        if (attr.scope() == Scope.SESSION) {
            return new SessionAttrInjector(attr.value());
        }
        if (attr.scope() == Scope.REQUEST) {
            return new RequestAttrInjector(attr.value());
        }
        return new AllAttrInjector(attr.value());
    }

    private static ParamInjector evalInjectorByParamType(Class<?> type) {
        if (ServletRequest.class.isAssignableFrom(type)) {
            return new RequestInjector();
        }
        if (ServletResponse.class.isAssignableFrom(type)) {
            return new ResponseInjector();
        }
        if (HttpSession.class.isAssignableFrom(type)) {
            return new SessionInjector();
        }
        if (ServletContext.class.isAssignableFrom(type)) {
            return new ServletContextInjector();
        }
        if (Ioc.class.isAssignableFrom(type)) {
            return new IocInjector();
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return new HttpInputStreamInjector();
        }
        if (Reader.class.isAssignableFrom(type)) {
            return new HttpReaderInjector();
        }
        return null;
    }

    protected ParamInjector evalInjector(Type type, Param param) {
        return this.evalInjectorBy(type, param);
    }

    protected abstract ParamInjector evalInjectorBy(Type var1, Param var2);

    @Override
    public Object[] adapt(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, String[] pathArgs) {
        Object obj;
        Object[] args = new Object[this.argTypes.length];
        if (args.length != this.injs.length) {
            throw new IllegalArgumentException("args.length != injs.length , You get a bug, pls report it!!");
        }
        AdaptorErrorContext errCtx = null;
        if (this.argTypes.length > 0 && AdaptorErrorContext.class.isAssignableFrom(this.argTypes[this.argTypes.length - 1])) {
            errCtx = (AdaptorErrorContext)((Object)Mirror.me(this.argTypes[this.argTypes.length - 1]).born(this.argTypes.length));
        }
        try {
            obj = this.getReferObject(sc, req, resp, pathArgs);
        }
        catch (Throwable e) {
            if (errCtx != null) {
                if (log.isInfoEnabled()) {
                    log.info("Adapter Error catched , but I found AdaptorErrorContext param, so, set it to args, and continue", e);
                }
                errCtx.setAdaptorError(e, this);
                args[args.length - 1] = errCtx;
                return args;
            }
            throw Lang.wrapThrow(e);
        }
        int len = Math.min(args.length, pathArgs == null ? 0 : pathArgs.length);
        int i = 0;
        while (i < args.length) {
            Object value = null;
            value = i < len ? (pathArgs == null ? null : pathArgs[i]) : obj;
            try {
                args[i] = this.injs[i].get(sc, req, resp, value);
            }
            catch (Throwable e) {
                if (errCtx != null) {
                    log.infof("Adapter Param Error(%s) index=%d", this.method, i, e);
                    errCtx.setError(i, e, this.method, value, this.injs[i]);
                }
                throw Lang.wrapThrow(e);
            }
            if (args[i] == null && this.argTypes[i].isPrimitive()) {
                args[i] = Lang.getPrimitiveDefaultValue(this.argTypes[i]);
            }
            ++i;
        }
        if (errCtx == null) {
            return args;
        }
        Throwable[] throwableArray = errCtx.getErrors();
        int n = throwableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable err = throwableArray[n2];
            if (err != null) {
                int lastParam = this.argTypes.length - 1;
                if (AdaptorErrorContext.class.isAssignableFrom(this.argTypes[lastParam])) {
                    if (log.isInfoEnabled()) {
                        log.info("Adapter Param Error catched , but I found AdaptorErrorContext param, so, set it to args, and continue");
                    }
                    args[lastParam] = errCtx;
                    return args;
                }
                throw Lang.wrapThrow(err);
            }
            ++n2;
        }
        return args;
    }

    protected Object getReferObject(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, String[] pathArgs) {
        return null;
    }

    protected ParamInjector paramNameInject(Method method, int index) {
        if (!Lang.isAndroid) {
            List<String> names = MethodParamNamesScaner.getParamNames(method);
            if (names != null) {
                return new NameInjector(names.get(index), null, method.getParameterTypes()[index], null);
            }
            if (log.isInfoEnabled()) {
                log.infof("Complie without debug info? can't deduce param name. fail back to PathArgInjector!! index=%d > %s", index, method);
            }
        }
        return new PathArgInjector(method.getParameterTypes()[index]);
    }
}

