/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.convertor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nutz.castor.Castors;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.mvc.adaptor.ParamConvertor;

public class DateParamConvertor
implements ParamConvertor {
    private Class<?> type;
    private DateFormat dfmt;

    public DateParamConvertor(Class<?> type, String datefmt) {
        this.type = type;
        this.dfmt = Strings.isBlank(datefmt) ? null : new SimpleDateFormat(datefmt);
    }

    @Override
    public Object convert(String[] ss) {
        if (ss == null || ss.length == 0) {
            return null;
        }
        if (Strings.isBlank(ss[0])) {
            return null;
        }
        if (this.dfmt != null) {
            Date o = Times.parseq(this.dfmt, ss[0]);
            return Castors.me().castTo(o, this.type);
        }
        return Castors.me().cast(ss[0], String.class, this.type, new String[0]);
    }
}

