/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.mvc.adaptor.injector.NameInjector;

public class ArrayInjector
extends NameInjector {
    public ArrayInjector(String name, Class<?> type, Type[] paramTypes) {
        super(name, null, type, paramTypes);
    }

    @Override
    public Object get(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, Object refer) {
        String[] values;
        Object value = null;
        if (refer != null) {
            if (refer instanceof Map && (value = (Object)((Map)refer).get(this.name)) != null && value.getClass().isArray()) {
                return Lang.array2array(value, this.type.getComponentType());
            }
            if (value != null) {
                return this.convertMe(value);
            }
        }
        if ((values = req.getParameterValues(this.name)) == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return this.convertMe(values[0]);
        }
        return Lang.array2array(values, this.type.getComponentType());
    }

    protected Object convertMe(Object value) {
        try {
            return Castors.me().castTo(value, this.type);
        }
        catch (Exception exception) {
            Object re = Array.newInstance(this.type.getComponentType(), 1);
            Object v = Castors.me().castTo(value, this.type.getComponentType());
            Array.set(re, 0, v);
            return re;
        }
    }
}

