/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ObjectNaviNode {
    private static final char separator = '.';
    private static final char LIST_SEPARATOR = ':';
    private static final int TYPE_NONE = 0;
    private static final int TYPE_LIST = 1;
    private String name;
    private String[] value;
    private boolean leaf = true;
    private Map<String, ObjectNaviNode> child = new HashMap<String, ObjectNaviNode>();
    private int type = 0;

    public void put(String path, String[] value) {
        path = path.replace("[", ":");
        path = path.replace("]", "");
        path = path.replace("(", ".");
        path = path.replace(")", "");
        this.putPath(path, value);
    }

    private void putPath(String path, String[] value) {
        this.init(path);
        String subPath = this.fetchSubPath(path);
        if ("".equals(subPath) || path.equals(subPath)) {
            this.value = value;
            return;
        }
        this.leaf = false;
        this.addChild(subPath, value);
    }

    private void addChild(String path, String[] value) {
        String subname = this.fetchName(path);
        ObjectNaviNode onn = this.child.get(subname);
        if (onn == null) {
            onn = new ObjectNaviNode();
        }
        onn.putPath(path, value);
        this.child.put(subname, onn);
    }

    private void init(String path) {
        String key = this.fetchNode(path);
        if (this.isList(key)) {
            this.type = 1;
            this.name = key.substring(0, key.indexOf(58));
            return;
        }
        this.name = key;
    }

    private String fetchSubPath(String path) {
        if (this.isList(this.fetchNode(path))) {
            return path.substring(path.indexOf(58) + 1);
        }
        return path.substring(path.indexOf(46) + 1);
    }

    private String fetchNode(String path) {
        if (path.indexOf(46) <= 0) {
            return path;
        }
        return path.substring(0, path.indexOf(46));
    }

    private String fetchName(String path) {
        String key = this.fetchNode(path);
        if (this.isList(key)) {
            return key.substring(0, key.indexOf(58));
        }
        return key;
    }

    public Object get() {
        if (this.isLeaf()) {
            return this.value == null ? null : (this.value.length == 1 ? this.value[0] : this.value);
        }
        if (this.type == 1) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (String o : this.child.keySet()) {
                list.add(this.child.get(o).get());
            }
            return list;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String o : this.child.keySet()) {
            map.put(o, this.child.get(o).get());
        }
        return map;
    }

    private boolean isList(String key) {
        return key.indexOf(58) > 0;
    }

    public String getName() {
        return this.name;
    }

    public String[] getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return this.leaf;
    }
}

