/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.inject.Injecting;
import org.nutz.mvc.adaptor.ParamConvertor;
import org.nutz.mvc.adaptor.ParamExtractor;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.adaptor.Params;
import org.nutz.mvc.annotation.Param;

public class ObjectPairInjector
implements ParamInjector {
    protected Injecting[] injs;
    protected String[] names;
    protected Mirror<?> mirror;
    protected Field[] fields;
    protected ParamConvertor[] converters;

    public ObjectPairInjector(String prefix, Type type) {
        prefix = Strings.isBlank(prefix) ? "" : Strings.trim(prefix);
        this.mirror = Mirror.me(type);
        this.fields = this.mirror.getFields();
        this.injs = new Injecting[this.fields.length];
        this.names = new String[this.fields.length];
        this.converters = new ParamConvertor[this.fields.length];
        int i = 0;
        while (i < this.fields.length) {
            Field f = this.fields[i];
            this.injs[i] = this.mirror.getInjecting(f.getName());
            Param param = f.getAnnotation(Param.class);
            String nm = param == null ? f.getName() : param.value();
            String datefmt = param == null ? null : param.dfmt();
            this.names[i] = String.valueOf(prefix) + nm;
            this.converters[i] = Params.makeParamConvertor(f.getType(), datefmt);
            ++i;
        }
    }

    @Override
    public Object get(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, Object refer) {
        ParamExtractor pe = Params.makeParamExtractor(req, refer);
        Object obj = this.mirror.born(new Object[0]);
        int i = 0;
        while (i < this.injs.length) {
            Object param = this.converters[i].convert(pe.extractor(this.names[i]));
            if (param != null) {
                this.injs[i].inject(obj, param);
            }
            ++i;
        }
        return obj;
    }
}

