/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.ioc.annotation.InjectName;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.Segments;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionFilter;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.HttpAdaptor;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.ObjectInfo;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.By;
import org.nutz.mvc.annotation.Chain;
import org.nutz.mvc.annotation.DELETE;
import org.nutz.mvc.annotation.Encoding;
import org.nutz.mvc.annotation.Fail;
import org.nutz.mvc.annotation.Filters;
import org.nutz.mvc.annotation.GET;
import org.nutz.mvc.annotation.Modules;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.PUT;
import org.nutz.mvc.annotation.PathMap;
import org.nutz.resource.Scans;

public abstract class Loadings {
    private static final Log log = Logs.get();

    public static ActionInfo createInfo(Class<?> type) {
        ActionInfo ai = new ActionInfo();
        Loadings.evalEncoding(ai, type.getAnnotation(Encoding.class));
        Loadings.evalHttpAdaptor(ai, type.getAnnotation(AdaptBy.class));
        Loadings.evalActionFilters(ai, type.getAnnotation(Filters.class));
        Loadings.evalPathMap(ai, type.getAnnotation(PathMap.class));
        Loadings.evalOk(ai, type.getAnnotation(Ok.class));
        Loadings.evalFail(ai, type.getAnnotation(Fail.class));
        Loadings.evalAt(ai, type.getAnnotation(At.class), type.getSimpleName());
        Loadings.evalActionChainMaker(ai, type.getAnnotation(Chain.class));
        Loadings.evalModule(ai, type);
        return ai;
    }

    public static ActionInfo createInfo(Method method) {
        ActionInfo ai = new ActionInfo();
        Loadings.evalEncoding(ai, method.getAnnotation(Encoding.class));
        Loadings.evalHttpAdaptor(ai, method.getAnnotation(AdaptBy.class));
        Loadings.evalActionFilters(ai, method.getAnnotation(Filters.class));
        Loadings.evalOk(ai, method.getAnnotation(Ok.class));
        Loadings.evalFail(ai, method.getAnnotation(Fail.class));
        Loadings.evalAt(ai, method.getAnnotation(At.class), method.getName());
        Loadings.evalActionChainMaker(ai, method.getAnnotation(Chain.class));
        Loadings.evalHttpMethod(ai, method);
        ai.setMethod(method);
        return ai;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanModules(Class<?> mainModule) {
        int n;
        Modules ann = mainModule.getAnnotation(Modules.class);
        boolean scan = ann == null ? false : ann.scanPackage();
        LinkedList list = new LinkedList();
        list.add(mainModule);
        if (ann != null) {
            void var5_9;
            Class<?>[] classArray = ann.value();
            n = classArray.length;
            boolean n2 = false;
            while (var5_9 < n) {
                Class<?> module = classArray[var5_9];
                list.add(module);
                ++var5_9;
            }
        }
        HashSet modules = new HashSet();
        if (ann != null && ann.packages() != null && ann.packages().length > 0) {
            String[] stringArray = ann.packages();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String string = stringArray[n];
                Loadings.scanModuleInPackage(modules, string);
                ++n;
            }
        }
        for (Class clazz : list) {
            try {
                URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
                if (log.isDebugEnabled()) {
                    log.debugf("module class location '%s'", location);
                }
            }
            catch (NullPointerException nullPointerException) {}
            Scans.me().registerLocation(clazz);
        }
        for (Class clazz : list) {
            if (scan) {
                Loadings.scanModuleInPackage(modules, clazz.getPackage().getName());
                continue;
            }
            if (Loadings.isModule(clazz)) {
                if (log.isDebugEnabled()) {
                    log.debugf(" > add '%s'", clazz.getName());
                }
                modules.add(clazz);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.tracef(" > ignore '%s'", clazz.getName());
        }
        return modules;
    }

    protected static void scanModuleInPackage(Set<Class<?>> modules, String packageName) {
        if (log.isDebugEnabled()) {
            log.debugf(" > scan '%s'", packageName);
        }
        List<Class<?>> subs = Scans.me().scanPackage(packageName);
        Loadings.checkModule(modules, subs);
    }

    private static void checkModule(Set<Class<?>> modules, List<Class<?>> subs) {
        for (Class<?> sub : subs) {
            if (Loadings.isModule(sub)) {
                if (log.isDebugEnabled()) {
                    log.debugf("   >> add '%s'", sub.getName());
                }
                modules.add(sub);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.tracef("   >> ignore '%s'", sub.getName());
        }
    }

    public static void evalHttpMethod(ActionInfo ai, Method method) {
        if (method.getAnnotation(GET.class) != null) {
            ai.getHttpMethods().add("GET");
        }
        if (method.getAnnotation(POST.class) != null) {
            ai.getHttpMethods().add("POST");
        }
        if (method.getAnnotation(PUT.class) != null) {
            ai.getHttpMethods().add("PUT");
        }
        if (method.getAnnotation(DELETE.class) != null) {
            ai.getHttpMethods().add("DELETE");
        }
    }

    public static void evalActionChainMaker(ActionInfo ai, Chain cb) {
        if (cb != null) {
            ai.setChainName(cb.value());
        }
    }

    public static void evalAt(ActionInfo ai, At at, String def) {
        if (at != null) {
            if (at.value() == null || at.value().length == 0) {
                ai.setPaths(Lang.array("/" + def.toLowerCase()));
            } else {
                ai.setPaths(at.value());
            }
            if (!Strings.isBlank(at.key())) {
                ai.setPathKey(at.key());
            }
        }
    }

    private static void evalPathMap(ActionInfo ai, PathMap pathMap) {
        if (pathMap != null) {
            ai.setPathMap(Json.fromJson(Map.class, (CharSequence)pathMap.value()));
        }
    }

    public static void evalFail(ActionInfo ai, Fail fail) {
        if (fail != null) {
            ai.setFailView(fail.value());
        }
    }

    public static void evalOk(ActionInfo ai, Ok ok) {
        if (ok != null) {
            ai.setOkView(ok.value());
        }
    }

    public static void evalModule(ActionInfo ai, Class<?> type) {
        ai.setModuleType(type);
        String beanName = null;
        InjectName innm = type.getAnnotation(InjectName.class);
        IocBean iocBean = type.getAnnotation(IocBean.class);
        if (innm == null && iocBean == null) {
            return;
        }
        if (iocBean != null) {
            beanName = iocBean.name();
        }
        if (Strings.isBlank(beanName)) {
            beanName = innm != null && !Strings.isBlank(innm.value()) ? innm.value() : Strings.lowerFirst(type.getSimpleName());
        }
        ai.setInjectName(beanName);
    }

    public static void evalActionFilters(ActionInfo ai, Filters filters) {
        if (filters != null) {
            ArrayList<ObjectInfo<? extends ActionFilter>> list = new ArrayList<ObjectInfo<? extends ActionFilter>>(filters.value().length);
            By[] byArray = filters.value();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                By by = byArray[n2];
                list.add(new ObjectInfo<ActionFilter>(by.type(), by.args()));
                ++n2;
            }
            ai.setFilterInfos(list.toArray(new ObjectInfo[list.size()]));
        }
    }

    public static void evalHttpAdaptor(ActionInfo ai, AdaptBy ab) {
        if (ab != null) {
            ai.setAdaptorInfo(new ObjectInfo<HttpAdaptor>(ab.type(), ab.args()));
        }
    }

    public static void evalEncoding(ActionInfo ai, Encoding encoding) {
        if (encoding == null) {
            ai.setInputEncoding("UTF-8");
            ai.setOutputEncoding("UTF-8");
        } else {
            ai.setInputEncoding(Strings.sNull(encoding.input(), "UTF-8"));
            ai.setOutputEncoding(Strings.sNull(encoding.output(), "UTF-8"));
        }
    }

    public static <T> T evalObj(NutConfig config, Class<T> type, String[] args) {
        Context context = config.getLoadingContext();
        int i = 0;
        while (i < args.length) {
            args[i] = Segments.replace(args[i], context);
            ++i;
        }
        if (args.length == 1 && args[0].startsWith("ioc:")) {
            String name = Strings.trim(args[0].substring(4));
            return config.getIoc().get(type, name);
        }
        return (T)Mirror.me(type).born(args);
    }

    public static boolean isModule(Class<?> classZ) {
        int classModify = classZ.getModifiers();
        if (!Modifier.isPublic(classModify) || Modifier.isAbstract(classModify) || Modifier.isInterface(classModify)) {
            return false;
        }
        Method[] methodArray = classZ.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(At.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

