/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.mvc.ActionContext;

public class MappingNode<T> {
    private T obj;
    private T asterisk;
    private MappingNode<T> quesmark;
    private Map<String, MappingNode<T>> map = new HashMap<String, MappingNode<T>>();

    private void add(Iterator<String> it, T obj) {
        if (it.hasNext()) {
            String key = it.next().toLowerCase();
            if ("*".equals(key)) {
                if (it.hasNext()) {
                    throw Lang.makeThrow("char '*' should be the last item in a Path '../*/%s/..'", it.next());
                }
                this.asterisk = obj;
            } else if ("?".equals(key)) {
                if (this.quesmark == null) {
                    this.quesmark = new MappingNode<T>();
                }
                super.add(it, obj);
            } else {
                MappingNode<T> node = this.map.get(key);
                if (node == null) {
                    node = new MappingNode<T>();
                    this.map.put(key, node);
                }
                super.add(it, obj);
            }
        } else {
            this.obj = obj;
        }
    }

    private T get(ActionContext ac, Iterator<String> it) {
        if (!it.hasNext()) {
            return this.obj == null ? this.asterisk : this.obj;
        }
        String key = it.next();
        MappingNode<T> node = this.map.get(key.toLowerCase());
        if (node != null) {
            return super.get(ac, it);
        }
        if (this.quesmark != null) {
            ac.getPathArgs().add(key);
            return super.get(ac, it);
        }
        if (this.asterisk != null) {
            List<String> pathArgs = ac.getPathArgs();
            pathArgs.add(key);
            while (it.hasNext()) {
                pathArgs.add(it.next());
            }
            return this.asterisk;
        }
        return null;
    }

    public void add(String path, T obj) {
        try {
            this.add(Lang.list(Strings.splitIgnoreBlank(path, "/")).iterator(), obj);
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e, "Wrong Url path format '%s'", path);
        }
    }

    public T get(ActionContext ac, String path) {
        ac.setPath(path);
        ac.setPathArgs(new LinkedList<String>());
        return this.get(ac, Lang.list(Strings.splitIgnoreBlank(path, "/")).iterator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb, 0);
        return sb.toString();
    }

    private void appendTo(StringBuilder sb, int indent) {
        String prefix = Strings.dup("   ", indent);
        sb.append(prefix).append('<').append(Strings.sNull(this.obj, "null")).append('>');
        prefix = "\n   " + prefix;
        if (this.asterisk != null) {
            sb.append(prefix).append(" * : ").append(this.asterisk.toString());
        }
        if (this.quesmark != null) {
            sb.append(prefix).append(" ? : ");
            super.appendTo(sb, indent + 1);
        }
        for (String key : this.map.keySet()) {
            sb.append(prefix).append(" '" + key + "' : ");
            super.appendTo(sb, indent + 1);
        }
    }
}

