/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.nutz.Nutz;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.Ioc2;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Stopwatch;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChainMaker;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.IocProvider;
import org.nutz.mvc.Loading;
import org.nutz.mvc.LoadingException;
import org.nutz.mvc.MessageLoader;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.SessionProvider;
import org.nutz.mvc.Setup;
import org.nutz.mvc.UrlMapping;
import org.nutz.mvc.ViewMaker;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.ChainBy;
import org.nutz.mvc.annotation.IocBy;
import org.nutz.mvc.annotation.Localization;
import org.nutz.mvc.annotation.SessionBy;
import org.nutz.mvc.annotation.SetupBy;
import org.nutz.mvc.annotation.UrlMappingBy;
import org.nutz.mvc.annotation.Views;
import org.nutz.mvc.impl.Loadings;
import org.nutz.mvc.impl.NutActionChainMaker;
import org.nutz.mvc.impl.ServletValueProxyMaker;
import org.nutz.mvc.impl.UrlMappingImpl;
import org.nutz.mvc.view.DefaultViewMaker;

public class NutLoading
implements Loading {
    private static final Log log = Logs.get();

    @Override
    public UrlMapping load(NutConfig config) {
        UrlMapping mapping;
        if (log.isInfoEnabled()) {
            log.infof("Nutz Version : %s ", Nutz.version());
            log.infof("Nutz.Mvc[%s] is initializing ...", config.getAppName());
        }
        if (log.isDebugEnabled()) {
            Properties sys = System.getProperties();
            log.debug("Web Container Information:");
            log.debugf(" - Default Charset : %s", Encoding.defaultEncoding());
            log.debugf(" - Current . path  : %s", new File(".").getAbsolutePath());
            log.debugf(" - Java Version    : %s", sys.get("java.version"));
            log.debugf(" - File separator  : %s", sys.get("file.separator"));
            log.debugf(" - Timezone        : %s", sys.get("user.timezone"));
            log.debugf(" - OS              : %s %s", sys.get("os.name"), sys.get("os.arch"));
            log.debugf(" - ServerInfo      : %s", config.getServletContext().getServerInfo());
            if (config.getServletContext().getMajorVersion() > 2 || config.getServletContext().getMinorVersion() > 4) {
                log.debugf(" - ContextPath     : %s", config.getServletContext().getContextPath());
            }
        }
        Stopwatch sw = Stopwatch.begin();
        try {
            Class<?> mainModule = config.getMainModule();
            this.createContext(config);
            Ioc ioc = this.createIoc(config, mainModule);
            mapping = this.evalUrlMapping(config, mainModule, ioc);
            this.evalLocalization(config, mainModule);
            this.createSessionProvider(config, mainModule);
            this.evalSetup(config, mainModule);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error happend during start serivce!", e);
            }
            throw Lang.wrapThrow(e, LoadingException.class);
        }
        sw.stop();
        if (log.isInfoEnabled()) {
            log.infof("Nutz.Mvc[%s] is up in %sms", config.getAppName(), sw.getDuration());
        }
        return mapping;
    }

    protected UrlMapping evalUrlMapping(NutConfig config, Class<?> mainModule, Ioc ioc) throws Exception {
        UrlMapping mapping = this.createUrlMapping(config);
        if (log.isInfoEnabled()) {
            log.infof("Build URL mapping by %s ...", mapping.getClass().getName());
        }
        ViewMaker[] makers = this.createViewMakers(mainModule, ioc);
        ActionChainMaker maker = this.createChainMaker(config, mainModule);
        ActionInfo mainInfo = Loadings.createInfo(mainModule);
        Set<Class<?>> modules = Loadings.scanModules(mainModule);
        if (modules.isEmpty() && log.isWarnEnabled()) {
            log.warn("None module classes found!!!");
        }
        int atMethods = 0;
        for (Class<?> module : modules) {
            ActionInfo moduleInfo = Loadings.createInfo(module).mergeWith(mainInfo);
            Method[] methodArray = module.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (Modifier.isPublic(method.getModifiers()) && method.isAnnotationPresent(At.class)) {
                    ActionInfo info = Loadings.createInfo(method).mergeWith(moduleInfo);
                    info.setViewMakers(makers);
                    mapping.add(maker, info, config);
                    ++atMethods;
                }
                ++n2;
            }
            if (moduleInfo.getPathMap() == null) continue;
            for (Map.Entry<String, String> en : moduleInfo.getPathMap().entrySet()) {
                config.getAtMap().add(en.getKey(), en.getValue());
            }
        }
        if (atMethods == 0) {
            if (log.isWarnEnabled()) {
                log.warn("None @At found in any modules class!!");
            }
        } else {
            log.infof("Found %d module methods", atMethods);
        }
        return mapping;
    }

    protected void createContext(NutConfig config) {
        Context context = Lang.context();
        String appRoot = config.getAppRoot();
        context.set("app.root", appRoot);
        if (log.isDebugEnabled()) {
            log.debugf(">> app.root = %s", appRoot);
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            context.set("env." + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            context.set("sys." + entry.getKey(), entry.getValue());
        }
        if (log.isTraceEnabled()) {
            log.tracef(">>\nCONTEXT %s", Json.toJson(context, JsonFormat.nice()));
        }
        config.getServletContext().setAttribute("_NUTZ_LOADING_CONTEXT_", (Object)context);
    }

    protected UrlMapping createUrlMapping(NutConfig config) throws Exception {
        UrlMappingBy umb = config.getMainModule().getAnnotation(UrlMappingBy.class);
        if (umb != null) {
            return Loadings.evalObj(config, umb.value(), umb.args());
        }
        return new UrlMappingImpl();
    }

    protected ActionChainMaker createChainMaker(NutConfig config, Class<?> mainModule) {
        NutActionChainMaker maker;
        ChainBy ann = mainModule.getAnnotation(ChainBy.class);
        ActionChainMaker actionChainMaker = maker = ann == null ? new NutActionChainMaker(new String[0]) : Loadings.evalObj(config, ann.type(), ann.args());
        if (log.isDebugEnabled()) {
            log.debugf("@ChainBy(%s)", maker.getClass().getName());
        }
        return maker;
    }

    protected void evalSetup(NutConfig config, Class<?> mainModule) throws Exception {
        SetupBy sb = mainModule.getAnnotation(SetupBy.class);
        if (sb != null) {
            if (log.isInfoEnabled()) {
                log.info("Setup application...");
            }
            Setup setup = Loadings.evalObj(config, sb.value(), sb.args());
            config.setAttributeIgnoreNull(Setup.class.getName(), setup);
            setup.init(config);
        }
    }

    protected void evalLocalization(NutConfig config, Class<?> mainModule) {
        Localization lc = mainModule.getAnnotation(Localization.class);
        if (lc != null) {
            if (log.isDebugEnabled()) {
                log.debugf("Localization: %s('%s') %s dft<%s>", lc.type().getName(), lc.value(), Strings.isBlank(lc.beanName()) ? "" : "$ioc->" + lc.beanName(), lc.defaultLocalizationKey());
            }
            MessageLoader msgLoader = null;
            msgLoader = !Strings.isBlank(lc.beanName()) ? config.getIoc().get(lc.type(), lc.beanName()) : (MessageLoader)((Object)Mirror.me(lc.type()).born(new Object[0]));
            Map<String, Map<String, Object>> msgss = msgLoader.load(lc.value());
            Mvcs.setMessageSet(msgss);
            if (!Strings.isBlank(lc.defaultLocalizationKey())) {
                Mvcs.setDefaultLocalizationKey(lc.defaultLocalizationKey());
            }
        } else if (log.isDebugEnabled()) {
            log.debug("@Localization not define");
        }
    }

    protected ViewMaker[] createViewMakers(Class<?> mainModule, Ioc ioc) throws Exception {
        ViewMaker[] makers;
        Views vms = mainModule.getAnnotation(Views.class);
        int i = 0;
        if (vms != null) {
            makers = new ViewMaker[vms.value().length + 1];
            while (i < vms.value().length) {
                makers[i] = vms.value()[i].getAnnotation(IocBean.class) != null && ioc != null ? ioc.get(vms.value()[i]) : (ViewMaker)((Object)Mirror.me(vms.value()[i]).born(new Object[0]));
                ++i;
            }
        } else {
            makers = new ViewMaker[1];
        }
        makers[i] = new DefaultViewMaker();
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(makers[0].getClass().getSimpleName());
            i = 0;
            while (i < makers.length - 1) {
                sb.append(',').append(makers[i].getClass().getSimpleName());
                ++i;
            }
            log.debugf("@Views(%s)", sb);
        }
        return makers;
    }

    protected Ioc createIoc(NutConfig config, Class<?> mainModule) throws Exception {
        IocBy ib = mainModule.getAnnotation(IocBy.class);
        if (ib != null) {
            Ioc ioc;
            if (log.isDebugEnabled()) {
                log.debugf("@IocBy(type=%s, args=%s)", ib.type().getName(), ib.args());
            }
            if ((ioc = ((IocProvider)((Object)Mirror.me(ib.type()).born(new Object[0]))).create(config, ib.args())) instanceof Ioc2) {
                ((Ioc2)ioc).addValueProxyMaker(new ServletValueProxyMaker(config.getServletContext()));
            }
            Mvcs.setIoc(ioc);
            return ioc;
        }
        if (log.isInfoEnabled()) {
            log.info("!!!Your application without @IocBy supporting");
        }
        return null;
    }

    protected void createSessionProvider(NutConfig config, Class<?> mainModule) throws Exception {
        SessionBy sb = mainModule.getAnnotation(SessionBy.class);
        if (sb != null) {
            SessionProvider sp = null;
            sp = sb.args() != null && sb.args().length == 1 && sb.args()[0].startsWith("ioc:") ? config.getIoc().get(sb.value(), sb.args()[0].substring(4)) : (SessionProvider)((Object)Mirror.me(sb.value()).born(sb.args()));
            if (log.isInfoEnabled()) {
                log.info("SessionBy --> " + sp);
            }
            config.setSessionProvider(sp);
        }
    }

    @Override
    public void depose(NutConfig config) {
        if (log.isInfoEnabled()) {
            log.infof("Nutz.Mvc[%s] is deposing ...", config.getAppName());
        }
        Stopwatch sw = Stopwatch.begin();
        try {
            try {
                Setup setup = config.getAttributeAs(Setup.class, Setup.class.getName());
                if (setup != null) {
                    setup.destroy(config);
                }
            }
            catch (Exception e) {
                throw new LoadingException(e);
            }
        }
        finally {
            Ioc ioc;
            SessionProvider sp = config.getSessionProvider();
            if (sp != null) {
                sp.notifyStop();
            }
            if ((ioc = config.getIoc()) != null) {
                ioc.depose();
            }
        }
        sw.stop();
        if (log.isInfoEnabled()) {
            log.infof("Nutz.Mvc[%s] is down in %sms", config.getAppName(), sw.getDuration());
        }
    }
}

