/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChain;
import org.nutz.mvc.ActionChainMaker;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.UrlMapping;
import org.nutz.mvc.annotation.BlankAtException;
import org.nutz.mvc.impl.ActionInvoker;
import org.nutz.mvc.impl.MappingNode;

public class UrlMappingImpl
implements UrlMapping {
    private static final Log log = Logs.get();
    private Map<String, ActionInvoker> map = new HashMap<String, ActionInvoker>();
    private MappingNode<ActionInvoker> root = new MappingNode();

    @Override
    public void add(ActionChainMaker maker, ActionInfo ai, NutConfig config) {
        String path;
        String[] paths = ai.getPaths();
        int i = 0;
        while (i < paths.length) {
            path = paths[i];
            if (Strings.isBlank(path)) {
                throw new BlankAtException(ai.getModuleType(), ai.getMethod());
            }
            if (path.charAt(0) != '/') {
                paths[i] = String.valueOf('/') + path;
            }
            ++i;
        }
        ActionChain chain = maker.eval(config, ai);
        String[] stringArray = ai.getPaths();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            ActionInvoker invoker = this.map.get(path);
            if (invoker == null) {
                invoker = new ActionInvoker();
                this.map.put(path, invoker);
                this.root.add(path, invoker);
                config.getAtMap().addMethod(path, ai.getMethod());
            }
            if (ai.isForSpecialHttpMethod()) {
                for (String httpMethod : ai.getHttpMethods()) {
                    invoker.addChain(httpMethod, chain);
                }
            } else {
                invoker.setDefaultChain(chain);
            }
            ++n2;
        }
        this.printActionMapping(ai);
        if (!Strings.isBlank(ai.getPathKey())) {
            config.getAtMap().add(ai.getPathKey(), ai.getPaths()[0]);
        }
    }

    @Override
    public ActionInvoker get(ActionContext ac) {
        ActionChain chain;
        String path = Mvcs.getRequestPath(ac.getRequest());
        ActionInvoker invoker = this.root.get(ac, path);
        if (invoker != null && (chain = invoker.getActionChain(ac)) != null) {
            if (log.isDebugEnabled()) {
                log.debugf("Found mapping for [%s] path=%s : %s", ac.getRequest().getMethod(), path, chain);
            }
            return invoker;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Search mapping for path=%s : NOT Action match", path);
        }
        return null;
    }

    protected void printActionMapping(ActionInfo ai) {
        if (log.isDebugEnabled()) {
            String[] paths = ai.getPaths();
            StringBuilder sb = new StringBuilder();
            if (paths != null && paths.length > 0) {
                sb.append("   '").append(paths[0]).append("'");
                int i = 1;
                while (i < paths.length) {
                    sb.append(", '").append(paths[i]).append("'");
                    ++i;
                }
            } else {
                throw Lang.impossible();
            }
            Method method = ai.getMethod();
            if (method == null) {
                throw Lang.impossible();
            }
            String str = String.format("%-30s : %-10s", Lang.simpleMetodDesc(method), method.getReturnType().getSimpleName());
            log.debugf("%s >> %s | @Ok(%-5s) @Fail(%-5s) | by %d Filters | (I:%s/O:%s)", Strings.alignLeft(sb, 30, ' '), str, ai.getOkView(), ai.getFailView(), ai.getFilterInfos() == null ? 0 : ai.getFilterInfos().length, ai.getInputEncoding(), ai.getOutputEncoding());
        }
    }
}

