/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.processor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.Ioc2;
import org.nutz.ioc.impl.ComboContext;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.NutSessionListener;
import org.nutz.mvc.impl.processor.AbstractProcessor;
import org.nutz.mvc.ioc.RequestIocContext;
import org.nutz.mvc.ioc.SessionIocContext;

public class ModuleProcessor
extends AbstractProcessor {
    private static final Log log = Logs.get();
    private String injectName;
    private Class<?> moduleType;
    private Method method;
    private Object moduleObj;
    private static Map<String, Object> modulesMap = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(NutConfig config, ActionInfo ai) throws Throwable {
        this.method = ai.getMethod();
        this.moduleType = ai.getModuleType();
        if (Strings.isBlank(ai.getInjectName())) {
            Map<String, Object> map = modulesMap;
            synchronized (map) {
                String className = this.moduleType.getName();
                this.moduleObj = modulesMap.get(className);
                if (this.moduleObj == null) {
                    if (log.isInfoEnabled()) {
                        log.info("Create Module obj without Ioc --> " + this.moduleType);
                    }
                    this.moduleObj = Mirror.me(this.moduleType).born(new Object[0]);
                    modulesMap.put(className, this.moduleObj);
                }
            }
        } else {
            this.injectName = ai.getInjectName();
        }
    }

    @Override
    public void process(ActionContext ac) throws Throwable {
        RequestIocContext reqContext = null;
        try {
            if (this.moduleObj != null) {
                ac.setModule(this.moduleObj);
            } else {
                Object obj;
                Ioc ioc = ac.getIoc();
                if (ioc == null) {
                    throw Lang.makeThrow("Moudle with @InjectName('%s') or @IocBean('%s') but you not declare a Ioc for this app", this.injectName, this.injectName);
                }
                if (NutSessionListener.isSessionScopeEnable && ioc instanceof Ioc2) {
                    reqContext = new RequestIocContext((ServletRequest)ac.getRequest());
                    SessionIocContext sessionContext = new SessionIocContext(Mvcs.getHttpSession());
                    ComboContext myContext = new ComboContext(reqContext, sessionContext);
                    Mvcs.setIocContext(myContext);
                    obj = ((Ioc2)ioc).get(this.moduleType, this.injectName, myContext);
                } else {
                    obj = ioc.get(this.moduleType, this.injectName);
                }
                ac.setModule(obj);
            }
            ac.setMethod(this.method);
            this.doNext(ac);
        }
        finally {
            block14: {
                if (reqContext != null) {
                    try {
                        reqContext.depose();
                    }
                    catch (Throwable e) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug("ReqContext depose fail?!", e);
                    }
                }
            }
        }
    }
}

