/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.processor;

import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.View;
import org.nutz.mvc.ViewMaker;
import org.nutz.mvc.ViewMaker2;
import org.nutz.mvc.impl.processor.AbstractProcessor;
import org.nutz.mvc.view.ViewWrapper;
import org.nutz.mvc.view.VoidView;

public class ViewProcessor
extends AbstractProcessor {
    protected View view;
    public static final String DEFAULT_ATTRIBUTE = "obj";
    private static final Log log = Logs.get();

    @Override
    public void init(NutConfig config, ActionInfo ai) throws Throwable {
        if ("json".equals(ai.getOkView()) && String.class.equals(ai.getMethod().getReturnType())) {
            log.warn("Not a good idea : Return String ,and using JsonView!! (Using @Ok(\"raw\") or return map/list/pojo)--> " + Lang.simpleMetodDesc(ai.getMethod()));
        }
        this.view = ViewProcessor.evalView(config, ai, ai.getOkView());
    }

    @Override
    public void process(ActionContext ac) throws Throwable {
        Object re = ac.getMethodReturn();
        Throwable err = ac.getError();
        if (re != null && re instanceof View) {
            if (re instanceof ViewWrapper) {
                ViewProcessor.putRequestAttribute(ac.getRequest(), ((ViewWrapper)re).getData());
            }
            ((View)re).render(ac.getRequest(), ac.getResponse(), err);
        } else {
            ViewProcessor.putRequestAttribute(ac.getRequest(), re == null ? err : re);
            this.view.render(ac.getRequest(), ac.getResponse(), re == null ? err : re);
        }
        this.doNext(ac);
    }

    public static void putRequestAttribute(HttpServletRequest req, Object re) {
        if (re != null) {
            if (re instanceof Context) {
                Context context = (Context)re;
                for (String key : context.keys()) {
                    req.setAttribute(key, context.get(key));
                }
            } else {
                req.setAttribute(DEFAULT_ATTRIBUTE, re);
            }
        }
    }

    public static View evalView(NutConfig config, ActionInfo ai, String viewType) {
        String value;
        String type;
        if (Strings.isBlank(viewType)) {
            return new VoidView();
        }
        String str = viewType;
        int pos = str.indexOf(58);
        if (pos > 0) {
            type = Strings.trim(str.substring(0, pos).toLowerCase());
            value = Strings.trim(pos >= str.length() - 1 ? null : str.substring(pos + 1));
        } else {
            type = str;
            value = null;
        }
        ViewMaker[] viewMakerArray = ai.getViewMakers();
        int n = viewMakerArray.length;
        int n2 = 0;
        while (n2 < n) {
            View view;
            ViewMaker maker = viewMakerArray[n2];
            if (maker instanceof ViewMaker2 && (view = ((ViewMaker2)maker).make(config, ai, type, value)) != null) {
                return view;
            }
            view = maker.make(config.getIoc(), type, value);
            if (view != null) {
                return view;
            }
            ++n2;
        }
        throw Lang.makeThrow("Can not eval %s(\"%s\") View for %s", viewType, str, ai.getMethod());
    }
}

