/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.ioc;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import org.nutz.ioc.IocContext;
import org.nutz.ioc.ObjectProxy;

public class RequestIocContext
implements IocContext {
    private ServletRequest req;

    public RequestIocContext(ServletRequest req) {
        this.req = req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ServletRequest servletRequest = this.req;
        synchronized (servletRequest) {
            Enumeration ems = this.req.getAttributeNames();
            ArrayList<String> keys = new ArrayList<String>();
            while (ems.hasMoreElements()) {
                Object value;
                String key = (String)ems.nextElement();
                if (key == null || !((value = this.req.getAttribute(key)) instanceof ObjectProxy)) continue;
                keys.add(key);
                ((ObjectProxy)value).depose();
            }
            for (String key : keys) {
                this.req.removeAttribute(key);
            }
        }
    }

    @Override
    public void depose() {
        this.clear();
        this.req = null;
    }

    @Override
    public ObjectProxy fetch(String name) {
        Object re = this.req.getAttribute(name);
        if (re == null) {
            return null;
        }
        if (re instanceof ObjectProxy) {
            return (ObjectProxy)re;
        }
        return new ObjectProxy().setObj(re);
    }

    @Override
    public boolean remove(String scope, String name) {
        if (scope != null && "request".equals(scope)) {
            this.req.removeAttribute(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean save(String scope, String name, ObjectProxy obj) {
        if (scope != null && "request".equals(scope)) {
            this.req.setAttribute(name, (Object)obj);
            return true;
        }
        return false;
    }

    public ServletRequest getReq() {
        return this.req;
    }
}

