/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.ioc;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.nutz.ioc.IocContext;
import org.nutz.ioc.ObjectProxy;

public class SessionIocContext
implements IocContext {
    private HttpSession session;

    public SessionIocContext(HttpSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            Enumeration ems = this.session.getAttributeNames();
            ArrayList<String> keys = new ArrayList<String>();
            while (ems.hasMoreElements()) {
                Object value;
                String key = (String)ems.nextElement();
                if (key == null || !((value = this.session.getAttribute(key)) instanceof ObjectProxy)) continue;
                keys.add(key);
                ((ObjectProxy)value).depose();
            }
            for (String key : keys) {
                this.session.removeAttribute(key);
            }
        }
    }

    @Override
    public void depose() {
        this.clear();
        this.session = null;
    }

    @Override
    public ObjectProxy fetch(String name) {
        Object re = this.session.getAttribute(name);
        if (re == null) {
            return null;
        }
        if (re instanceof ObjectProxy) {
            return (ObjectProxy)re;
        }
        return new ObjectProxy().setObj(re);
    }

    @Override
    public boolean remove(String scope, String name) {
        if (scope != null && "session".equals(scope)) {
            this.session.removeAttribute(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean save(String scope, String name, ObjectProxy obj) {
        if (scope != null && "session".equals(scope)) {
            this.session.setAttribute(name, (Object)obj);
            return true;
        }
        return false;
    }

    public HttpSession getSession() {
        return this.session;
    }
}

