/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.repo;

public class LevenshteinDistance {
    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int computeLevenshteinDistance(String str1, String str2) {
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        int i = 0;
        while (i <= str1.length()) {
            distance[i][0] = i;
            ++i;
        }
        int j = 1;
        while (j <= str2.length()) {
            distance[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= str1.length()) {
            int j2 = 1;
            while (j2 <= str2.length()) {
                distance[i][j2] = LevenshteinDistance.minimum(distance[i - 1][j2] + 1, distance[i][j2 - 1] + 1, distance[i - 1][j2 - 1] + (str1.charAt(i - 1) == str2.charAt(j2 - 1) ? 0 : 1));
                ++j2;
            }
            ++i;
        }
        return distance[str1.length()][str2.length()];
    }
}

