/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.runner;

import java.util.Date;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.runner.NutLock;

public abstract class NutRunner
implements Runnable {
    protected Log log;
    protected Thread myThread;
    protected String rnm;
    protected NutLock lock;
    protected int count;
    protected long interval;
    protected Date upAt;
    protected Date downAt;

    public NutRunner(String rname) {
        this.rnm = rname;
        this.count = 0;
        this.lock = new NutLock();
    }

    @Override
    public void run() {
        if (this.log == null) {
            this.log = Logs.get().setTag(this.rnm);
        }
        this.myThread = Thread.currentThread();
        this.reg(this);
        this.doIt();
        this.unreg(this);
    }

    public abstract long exec() throws Exception;

    public abstract void reg(NutRunner var1);

    public abstract void unreg(NutRunner var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt() {
        while (!this.lock.isStop()) {
            NutLock nutLock = this.lock;
            synchronized (nutLock) {
                try {
                    this.upAt = Times.now();
                    this.downAt = null;
                    this.log.debugf("%s [%d] : up", this.rnm, ++this.count);
                    this.interval = this.exec();
                    if (this.interval < 1L) {
                        this.interval = 1L;
                    }
                    this.downAt = Times.now();
                    this.log.debugf("%s [%d] : wait %ds(%dms)", this.rnm, this.count, this.interval / 1000L, this.interval);
                    this.lock.wait(this.interval);
                }
                catch (InterruptedException e) {
                    this.log.warn(String.format("%s has been interrupted", this.rnm), e);
                    break;
                }
                catch (Throwable e) {
                    this.log.warn(String.format("%s has some error", this.rnm), e);
                    try {
                        this.lock.wait(30000L);
                    }
                    catch (Throwable throwable) {
                        this.log.warn(String.format("%s has some error again", this.rnm), e);
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        return String.format("[%s:%d] %s/%s - %d", this.rnm, this.count, this.upAt == null ? "NONE" : Times.sDT(this.upAt), this.downAt == null ? "NONE" : Times.sDT(this.downAt), this.interval);
    }

    public boolean isWaiting() {
        return this.downAt != null;
    }

    public boolean isRunning() {
        return this.downAt == null;
    }

    public long getInterval() {
        return this.interval;
    }

    public Date getUpAt() {
        return this.upAt;
    }

    public Date getDownAt() {
        return this.downAt;
    }

    public String getName() {
        return this.rnm;
    }

    public int getCount() {
        return this.count;
    }

    public NutLock getLock() {
        return this.lock;
    }

    public boolean isAlive() {
        if (this.myThread != null) {
            return this.myThread.isAlive();
        }
        return false;
    }

    public void stop(Throwable err) {
        this.myThread.stop(err);
    }
}

