/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.service;

import java.util.List;
import org.nutz.dao.Chain;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.pager.Pager;
import org.nutz.lang.Each;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.service.Service;

public abstract class EntityService<T>
extends Service {
    private Mirror<T> mirror;
    private static final Log log = Logs.get();

    public EntityService() {
        block3: {
            try {
                Class entryClass = Mirror.getTypeParam(this.getClass(), 0);
                this.mirror = Mirror.me(entryClass);
                if (log.isDebugEnabled()) {
                    log.debugf("Get TypeParams for self : %s", entryClass.getName());
                }
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("!!!Fail to get TypeParams for self!", e);
            }
        }
    }

    public EntityService(Dao dao) {
        this();
        this.setDao(dao);
    }

    public EntityService(Dao dao, Class<T> entityType) {
        this.setEntityType(entityType);
        this.setDao(dao);
    }

    public Mirror<T> mirror() {
        return this.mirror;
    }

    public <C extends T> void setEntityType(Class<C> classOfT) {
        this.mirror = Mirror.me(classOfT);
    }

    public Entity<T> getEntity() {
        return this.dao().getEntity(this.mirror.getType());
    }

    public Class<T> getEntityClass() {
        return this.mirror.getType();
    }

    public int clear(Condition cnd) {
        return this.dao().clear(this.getEntityClass(), cnd);
    }

    public int clear() {
        return this.dao().clear(this.getEntityClass(), null);
    }

    public List<T> query(Condition cnd, Pager pager) {
        return this.dao().query(this.getEntityClass(), cnd, pager);
    }

    public int each(Condition cnd, Pager pager, Each<T> callback) {
        return this.dao().each(this.getEntityClass(), cnd, pager, callback);
    }

    public int count(Condition cnd) {
        return this.dao().count(this.getEntityClass(), cnd);
    }

    public int count() {
        return this.dao().count(this.getEntityClass());
    }

    public T fetch(Condition cnd) {
        return this.dao().fetch(this.getEntityClass(), cnd);
    }

    public T fetchx(Object ... pks) {
        return this.dao().fetchx(this.getEntityClass(), pks);
    }

    public boolean exists(Object ... pks) {
        return this.fetchx(pks) != null;
    }

    public void update(Chain chain, Condition cnd) {
        this.dao().update(this.getEntityClass(), chain, cnd);
    }

    public void updateRelation(String regex, Chain chain, Condition cnd) {
        this.dao().updateRelation(this.getEntityClass(), regex, chain, cnd);
    }

    public int deletex(Object ... pks) {
        return this.dao().deletex(this.getEntityClass(), pks);
    }
}

