/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import org.openjdk.jol.util.ObjectUtils;
import org.openjdk.jol.vm.VM;

public class GraphPathRecord {
    private final String path;
    private final int depth;
    private Object obj;
    private final Class<?> klass;
    private final long size;
    private final long address;
    private final String toString;

    GraphPathRecord(String path, int depth, Object obj) {
        this(path, depth, obj, obj.getClass());
    }

    GraphPathRecord(String path, int depth, Class<?> klass) {
        this(path, depth, null, klass);
    }

    GraphPathRecord(String path, int depth, Object obj, Class<?> klass) {
        this.path = path;
        this.obj = obj;
        this.klass = klass;
        this.depth = depth;
        if (obj != null) {
            this.toString = ObjectUtils.safeToString(obj);
            this.size = VM.current().sizeOf(obj);
            this.address = VM.current().addressOf(obj);
        } else {
            this.toString = "(access denied)";
            this.size = 0L;
            this.address = 0L;
        }
    }

    Object obj() {
        return this.obj;
    }

    public String path() {
        return this.path;
    }

    public Class<?> klass() {
        return this.klass;
    }

    public long size() {
        return this.size;
    }

    public long address() {
        return this.address;
    }

    public String objToString() {
        return this.toString;
    }

    public int depth() {
        return this.depth;
    }
}

