/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.rmi.server.RMISocketFactory;
import org.ow2.carol.irmi.CountInputStream;
import org.ow2.carol.irmi.CountOutputStream;

public class CountSocketFactory
extends RMISocketFactory {
    public static final void install() {
        try {
            RMISocketFactory.setSocketFactory(new CountSocketFactory());
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private CountSocketFactory() {
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port){

            public Socket accept() throws IOException {
                final Socket delegate = super.accept();
                return new Socket(null){
                    private InputStream in;
                    private OutputStream out;
                    {
                        super(x0);
                        this.in = null;
                        this.out = null;
                    }

                    public void bind(SocketAddress bindpoint) throws IOException {
                        delegate.bind(bindpoint);
                    }

                    public void close() throws IOException {
                        delegate.close();
                    }

                    public void connect(SocketAddress endpoint) throws IOException {
                        delegate.connect(endpoint);
                    }

                    public void connect(SocketAddress endpoint, int timeout) throws IOException {
                        delegate.connect(endpoint, timeout);
                    }

                    public SocketChannel getChannel() {
                        return delegate.getChannel();
                    }

                    public InetAddress getInetAddress() {
                        return delegate.getInetAddress();
                    }

                    public InputStream getInputStream() throws IOException {
                        if (this.in == null) {
                            this.in = new CountInputStream(delegate.getInputStream());
                        }
                        return this.in;
                    }

                    public boolean getKeepAlive() throws SocketException {
                        return delegate.getKeepAlive();
                    }

                    public InetAddress getLocalAddress() {
                        return delegate.getLocalAddress();
                    }

                    public int getLocalPort() {
                        return delegate.getLocalPort();
                    }

                    public SocketAddress getLocalSocketAddress() {
                        return delegate.getLocalSocketAddress();
                    }

                    public boolean getOOBInline() throws SocketException {
                        return delegate.getOOBInline();
                    }

                    public OutputStream getOutputStream() throws IOException {
                        if (this.out == null) {
                            this.out = new CountOutputStream(delegate.getOutputStream());
                        }
                        return this.out;
                    }

                    public int getPort() {
                        return delegate.getPort();
                    }

                    public int getReceiveBufferSize() throws SocketException {
                        return delegate.getReceiveBufferSize();
                    }

                    public SocketAddress getRemoteSocketAddress() {
                        return delegate.getRemoteSocketAddress();
                    }

                    public boolean getReuseAddress() throws SocketException {
                        return delegate.getReuseAddress();
                    }

                    public int getSendBufferSize() throws SocketException {
                        return delegate.getSendBufferSize();
                    }

                    public int getSoLinger() throws SocketException {
                        return delegate.getSoLinger();
                    }

                    public int getSoTimeout() throws SocketException {
                        return delegate.getSoTimeout();
                    }

                    public boolean getTcpNoDelay() throws SocketException {
                        return delegate.getTcpNoDelay();
                    }

                    public int getTrafficClass() throws SocketException {
                        return delegate.getTrafficClass();
                    }

                    public boolean isBound() {
                        return delegate.isBound();
                    }

                    public boolean isClosed() {
                        return delegate.isClosed();
                    }

                    public boolean isConnected() {
                        return delegate.isConnected();
                    }

                    public boolean isInputShutdown() {
                        return delegate.isInputShutdown();
                    }

                    public boolean isOutputShutdown() {
                        return delegate.isOutputShutdown();
                    }

                    public void sendUrgentData(int data) throws IOException {
                        delegate.sendUrgentData(data);
                    }

                    public void setKeepAlive(boolean on) throws SocketException {
                        delegate.setKeepAlive(on);
                    }

                    public void setOOBInline(boolean on) throws SocketException {
                        delegate.setOOBInline(on);
                    }

                    public void setReceiveBufferSize(int size) throws SocketException {
                        delegate.setReceiveBufferSize(size);
                    }

                    public void setReuseAddress(boolean on) throws SocketException {
                        delegate.setReuseAddress(on);
                    }

                    public void setSendBufferSize(int size) throws SocketException {
                        delegate.setSendBufferSize(size);
                    }

                    public void setSoLinger(boolean on, int linger) throws SocketException {
                        delegate.setSoLinger(on, linger);
                    }

                    public void setSoTimeout(int timeout) throws SocketException {
                        delegate.setSoTimeout(timeout);
                    }

                    public void setTcpNoDelay(boolean on) throws SocketException {
                        delegate.setTcpNoDelay(on);
                    }

                    public void setTrafficClass(int tc) throws SocketException {
                        delegate.setTrafficClass(tc);
                    }

                    public void shutdownInput() throws IOException {
                        delegate.shutdownInput();
                    }

                    public void shutdownOutput() throws IOException {
                        delegate.shutdownOutput();
                    }

                    public String toString() {
                        return "<delegate for: " + delegate + ">";
                    }
                };
            }
        };
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port){
            private OutputStream out;
            private InputStream in;
            {
                this.out = null;
                this.in = null;
            }

            public OutputStream getOutputStream() throws IOException {
                if (this.out == null) {
                    this.out = new CountOutputStream(super.getOutputStream());
                }
                return this.out;
            }

            public InputStream getInputStream() throws IOException {
                if (this.in == null) {
                    this.in = new CountInputStream(super.getInputStream());
                }
                return this.in;
            }
        };
    }
}

