/*
 * Decompiled with CFR 0.152.
 */
package lombok.patcher;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeFinder {
    private static String urlDecode(String in) {
        try {
            return URLDecoder.decode(in, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            try {
                return URLDecoder.decode(in, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                return in;
            }
        }
    }

    public static String findHomeOfSelf() {
        return HomeFinder.findHomeOfClass(HomeFinder.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findHomeOfClass(Class<?> context) {
        URL selfURL;
        String self;
        String name = context.getName();
        int idx = name.lastIndexOf(46);
        if (idx > -1) {
            name = name.substring(idx + 1);
        }
        if ((self = (selfURL = context.getResource(name + ".class")).toString()).startsWith("file:/")) {
            String suffix;
            if (!(self = HomeFinder.urlDecode(self.substring(5))).endsWith(suffix = "/" + context.getPackage().getName().replace('.', '/') + "/" + name + ".class")) throw new IllegalArgumentException("Unknown path structure: " + self);
            self = self.substring(0, self.length() - suffix.length());
        } else {
            if (!self.startsWith("jar:")) throw new IllegalArgumentException("Unknown protocol: " + self);
            int sep = self.indexOf(33);
            if (sep == -1) {
                throw new IllegalArgumentException("No separator in jar protocol: " + self);
            }
            String jarLoc = self.substring(4, sep);
            if (!jarLoc.startsWith("file:/")) throw new IllegalArgumentException("Unknown path structure: " + self);
            int lastSlash = (jarLoc = HomeFinder.urlDecode(jarLoc.substring(5))).lastIndexOf(47);
            if (lastSlash > 0) {
                jarLoc = jarLoc.substring(0, lastSlash);
            }
            self = jarLoc;
        }
        if (!self.isEmpty()) return self;
        return "/";
    }

    public static void main(String[] args) {
        System.out.println(HomeFinder.findHomeOfSelf());
    }
}

