/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.apt;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import lombok.Lombok;
import lombok.javac.JavacTransformer;
import lombok.javac.apt.InterceptingJavaFileManager;
import lombok.javac.apt.MessagerDiagnosticsReceiver;

@SupportedAnnotationTypes(value={"*"})
public class Processor
extends AbstractProcessor {
    private JavacProcessingEnvironment processingEnv;
    private JavacTransformer transformer;
    private Trees trees;
    private boolean lombokDisabled = false;
    private final IdentityHashMap<JCTree.JCCompilationUnit, Long> roots = new IdentityHashMap();
    private long[] priorityLevels;
    private Set<Long> priorityLevelsRequiringResolutionReset;
    private int dummyCount = 0;

    @Override
    public void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        if (System.getProperty("lombok.disable") != null) {
            this.lombokDisabled = true;
            return;
        }
        this.processingEnv = (JavacProcessingEnvironment)procEnv;
        this.placePostCompileAndDontMakeForceRoundDummiesHook();
        this.transformer = new JavacTransformer(procEnv.getMessager());
        this.trees = Trees.instance(procEnv);
        SortedSet<Long> p = this.transformer.getPriorities();
        if (p.isEmpty()) {
            this.priorityLevels = new long[]{0L};
            this.priorityLevelsRequiringResolutionReset = new HashSet<Long>();
        } else {
            this.priorityLevels = new long[p.size()];
            int i = 0;
            for (Long prio : p) {
                this.priorityLevels[i++] = prio;
            }
            this.priorityLevelsRequiringResolutionReset = this.transformer.getPrioritiesRequiringResolutionReset();
        }
    }

    private void placePostCompileAndDontMakeForceRoundDummiesHook() {
        this.stopJavacProcessingEnvironmentFromClosingOurClassloader();
        this.forceMultipleRoundsInNetBeansEditor();
        Context context = this.processingEnv.getContext();
        this.disablePartialReparseInNetBeansEditor(context);
        try {
            Method keyMethod = Context.class.getDeclaredMethod("key", Class.class);
            keyMethod.setAccessible(true);
            Object key = keyMethod.invoke((Object)context, JavaFileManager.class);
            Field htField = Context.class.getDeclaredField("ht");
            htField.setAccessible(true);
            Map ht = (Map)htField.get(context);
            JavaFileManager originalFiler = (JavaFileManager)ht.get(key);
            if (!(originalFiler instanceof InterceptingJavaFileManager)) {
                Messager messager = this.processingEnv.getMessager();
                MessagerDiagnosticsReceiver receiver = new MessagerDiagnosticsReceiver(messager);
                InterceptingJavaFileManager newFiler = new InterceptingJavaFileManager(originalFiler, receiver);
                ht.put(key, newFiler);
                Field filerFileManagerField = JavacFiler.class.getDeclaredField("fileManager");
                filerFileManagerField.setAccessible(true);
                filerFileManagerField.set(this.processingEnv.getFiler(), newFiler);
            }
        }
        catch (Exception e) {
            throw Lombok.sneakyThrow(e);
        }
    }

    private void forceMultipleRoundsInNetBeansEditor() {
        try {
            Field f = JavacProcessingEnvironment.class.getDeclaredField("isBackgroundCompilation");
            f.setAccessible(true);
            f.set(this.processingEnv, true);
        }
        catch (NoSuchFieldException e) {
        }
        catch (Throwable t) {
            throw Lombok.sneakyThrow(t);
        }
    }

    private void disablePartialReparseInNetBeansEditor(Context context) {
        try {
            Class<?> cancelServiceClass = Class.forName("com.sun.tools.javac.util.CancelService");
            Method cancelServiceInstace = cancelServiceClass.getDeclaredMethod("instance", Context.class);
            Object cancelService = cancelServiceInstace.invoke(null, context);
            if (cancelService == null) {
                return;
            }
            Field parserField = cancelService.getClass().getDeclaredField("parser");
            parserField.setAccessible(true);
            Object parser = parserField.get(cancelService);
            Field supportsReparseField = parser.getClass().getDeclaredField("supportsReparse");
            supportsReparseField.setAccessible(true);
            supportsReparseField.set(parser, false);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (Throwable t) {
            throw Lombok.sneakyThrow(t);
        }
    }

    private static ClassLoader wrapClassLoader(final ClassLoader parent) {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return parent.loadClass(name);
            }

            public String toString() {
                return parent.toString();
            }

            @Override
            public URL getResource(String name) {
                return parent.getResource(name);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return parent.getResources(name);
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return parent.getResourceAsStream(name);
            }

            @Override
            public void setDefaultAssertionStatus(boolean enabled) {
                parent.setDefaultAssertionStatus(enabled);
            }

            @Override
            public void setPackageAssertionStatus(String packageName, boolean enabled) {
                parent.setPackageAssertionStatus(packageName, enabled);
            }

            @Override
            public void setClassAssertionStatus(String className, boolean enabled) {
                parent.setClassAssertionStatus(className, enabled);
            }

            @Override
            public void clearAssertionStatus() {
                parent.clearAssertionStatus();
            }
        };
    }

    private void stopJavacProcessingEnvironmentFromClosingOurClassloader() {
        try {
            Field f = JavacProcessingEnvironment.class.getDeclaredField("processorClassLoader");
            f.setAccessible(true);
            ClassLoader unwrapped = (ClassLoader)f.get(this.processingEnv);
            if (unwrapped == null) {
                return;
            }
            ClassLoader wrapped = Processor.wrapClassLoader(unwrapped);
            f.set(this.processingEnv, wrapped);
        }
        catch (NoSuchFieldException e) {
        }
        catch (Throwable t) {
            throw Lombok.sneakyThrow(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashSet<Long> newLevels;
        if (this.lombokDisabled) {
            return false;
        }
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit unit = this.toUnit(element);
            if (unit == null || this.roots.containsKey(unit)) continue;
            this.roots.put(unit, this.priorityLevels[0]);
        }
        do {
            void var4_6;
            for (long prio : this.priorityLevels) {
                ArrayList<JCTree.JCCompilationUnit> cusForThisRound = new ArrayList<JCTree.JCCompilationUnit>();
                for (Map.Entry<JCTree.JCCompilationUnit, Long> entry : this.roots.entrySet()) {
                    Long prioOfCu = entry.getValue();
                    if (prioOfCu == null || prioOfCu != prio) continue;
                    cusForThisRound.add(entry.getKey());
                }
                this.transformer.transform(prio, this.processingEnv.getContext(), cusForThisRound);
            }
            newLevels = new HashSet<Long>();
            int n = this.priorityLevels.length - 1;
            while (var4_6 >= 0) {
                Long curLevel = this.priorityLevels[var4_6];
                Long nextLevel = var4_6 == this.priorityLevels.length - 1 ? null : Long.valueOf(this.priorityLevels[var4_6 + true]);
                ArrayList<JCTree.JCCompilationUnit> cusToAdvance = new ArrayList<JCTree.JCCompilationUnit>();
                for (Map.Entry<JCTree.JCCompilationUnit, Long> entry : this.roots.entrySet()) {
                    if (!curLevel.equals(entry.getValue())) continue;
                    cusToAdvance.add(entry.getKey());
                    newLevels.add(nextLevel);
                }
                for (JCTree.JCCompilationUnit unit : cusToAdvance) {
                    this.roots.put(unit, nextLevel);
                }
                --var4_6;
            }
            newLevels.remove(null);
            if (newLevels.isEmpty()) {
                return false;
            }
            newLevels.retainAll(this.priorityLevelsRequiringResolutionReset);
        } while (newLevels.isEmpty());
        this.forceNewRound((JavacFiler)this.processingEnv.getFiler());
        return false;
    }

    private void forceNewRound(JavacFiler filer) {
        if (!filer.newFiles()) {
            try {
                JavaFileObject dummy = filer.createSourceFile("lombok.dummy.ForceNewRound" + this.dummyCount++, new Element[0]);
                Writer w = dummy.openWriter();
                w.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't force a new processing round. Lombok won't work.");
            }
        }
    }

    private JCTree.JCCompilationUnit toUnit(Element element) {
        TreePath path;
        TreePath treePath = path = this.trees == null ? null : this.trees.getPath(element);
        if (path == null) {
            return null;
        }
        return (JCTree.JCCompilationUnit)path.getCompilationUnit();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.values()[SourceVersion.values().length - 1];
    }
}

