/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.RedisResponseTimeoutException;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;

public class RedissonMultiLock
implements RLock {
    final List<RLock> locks = new ArrayList<RLock>();

    public RedissonMultiLock(RLock ... locks) {
        if (locks.length == 0) {
            throw new IllegalArgumentException("Lock objects are not defined");
        }
        this.locks.addAll(Arrays.asList(locks));
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        return this.lockAsync(leaseTime, unit, Thread.currentThread().getId());
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long threadId) {
        long baseWaitTime = this.locks.size() * 1500;
        long waitTime = -1L;
        waitTime = leaseTime == -1L ? baseWaitTime : ((waitTime = (leaseTime = unit.toMillis(leaseTime))) <= 2000L ? 2000L : (waitTime <= baseWaitTime ? ThreadLocalRandom.current().nextLong(waitTime / 2L, waitTime) : ThreadLocalRandom.current().nextLong(baseWaitTime, waitTime)));
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        this.tryLockAsync(threadId, leaseTime, TimeUnit.MILLISECONDS, waitTime, result);
        return result;
    }

    protected void tryLockAsync(long threadId, long leaseTime, TimeUnit unit, long waitTime, RPromise<Void> result) {
        this.tryLockAsync(waitTime, leaseTime, unit, threadId).onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                result.trySuccess(null);
            } else {
                this.tryLockAsync(threadId, leaseTime, unit, waitTime, result);
            }
        });
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        long baseWaitTime = this.locks.size() * 1500;
        long waitTime = -1L;
        waitTime = leaseTime == -1L ? baseWaitTime : ((waitTime = (leaseTime = unit.toMillis(leaseTime))) <= 2000L ? 2000L : (waitTime <= baseWaitTime ? ThreadLocalRandom.current().nextLong(waitTime / 2L, waitTime) : ThreadLocalRandom.current().nextLong(baseWaitTime, waitTime)));
        while (!this.tryLock(waitTime, leaseTime, TimeUnit.MILLISECONDS)) {
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(-1L, -1L, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void unlockInner(Collection<RLock> locks) {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(locks.size());
        for (RLock rLock : locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.awaitUninterruptibly();
        }
    }

    protected RFuture<Void> unlockInnerAsync(Collection<RLock> locks, long threadId) {
        if (locks.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        AtomicInteger counter = new AtomicInteger(locks.size());
        for (RLock lock : locks) {
            lock.unlockAsync(threadId).onComplete((res, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    return;
                }
                if (counter.decrementAndGet() == 0) {
                    result.trySuccess(null);
                }
            });
        }
        return result;
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    protected int failedLocksLimit() {
        return 0;
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long newLeaseTime = -1L;
        if (leaseTime != -1L) {
            newLeaseTime = unit.toMillis(waitTime) * 2L;
        }
        long time = System.currentTimeMillis();
        long remainTime = -1L;
        if (waitTime != -1L) {
            remainTime = unit.toMillis(waitTime);
        }
        long lockWaitTime = this.calcLockWaitTime(remainTime);
        int failedLocksLimit = this.failedLocksLimit();
        ArrayList<RLock> acquiredLocks = new ArrayList<RLock>(this.locks.size());
        ListIterator<RLock> iterator = this.locks.listIterator();
        while (iterator.hasNext()) {
            boolean lockAcquired;
            RLock lock = iterator.next();
            try {
                if (waitTime == -1L && leaseTime == -1L) {
                    lockAcquired = lock.tryLock();
                } else {
                    long awaitTime = Math.min(lockWaitTime, remainTime);
                    lockAcquired = lock.tryLock(awaitTime, newLeaseTime, TimeUnit.MILLISECONDS);
                }
            }
            catch (RedisResponseTimeoutException e) {
                this.unlockInner(Arrays.asList(lock));
                lockAcquired = false;
            }
            catch (Exception e) {
                lockAcquired = false;
            }
            if (lockAcquired) {
                acquiredLocks.add(lock);
            } else {
                if (this.locks.size() - acquiredLocks.size() == this.failedLocksLimit()) break;
                if (failedLocksLimit == 0) {
                    this.unlockInner(acquiredLocks);
                    if (waitTime == -1L && leaseTime == -1L) {
                        return false;
                    }
                    failedLocksLimit = this.failedLocksLimit();
                    acquiredLocks.clear();
                    while (iterator.hasPrevious()) {
                        iterator.previous();
                    }
                } else {
                    --failedLocksLimit;
                }
            }
            if (remainTime == -1L) continue;
            time = System.currentTimeMillis();
            if ((remainTime -= System.currentTimeMillis() - time) > 0L) continue;
            this.unlockInner(acquiredLocks);
            return false;
        }
        if (leaseTime != -1L) {
            ArrayList<RFuture> futures = new ArrayList<RFuture>(acquiredLocks.size());
            for (RLock rLock : acquiredLocks) {
                RFuture future = ((RedissonLock)rLock).expireAsync(unit.toMillis(leaseTime), TimeUnit.MILLISECONDS);
                futures.add(future);
            }
            for (RFuture rFuture : futures) {
                rFuture.syncUninterruptibly();
            }
        }
        return true;
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        LockState state = new LockState(waitTime, leaseTime, unit, threadId);
        state.tryAcquireLockAsync(this.locks.listIterator(), result);
        return result;
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, leaseTime, unit, Thread.currentThread().getId());
    }

    protected long calcLockWaitTime(long remainTime) {
        return remainTime;
    }

    @Override
    public RFuture<Void> unlockAsync(long threadId) {
        return this.unlockInnerAsync(this.locks, threadId);
    }

    @Override
    public void unlock() {
        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>(this.locks.size());
        for (RLock rLock : this.locks) {
            futures.add(rLock.unlockAsync());
        }
        for (RFuture rFuture : futures) {
            rFuture.syncUninterruptibly();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Void> unlockAsync() {
        return this.unlockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Void> lockAsync(long threadId) {
        return this.lockAsync(-1L, null, threadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        return this.tryLockAsync(-1L, -1L, null, threadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Integer> getHoldCountAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean forceUnlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> isLockedAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHeldByThread(long threadId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long remainTimeToLive() {
        throw new UnsupportedOperationException();
    }

    class LockState {
        private final long newLeaseTime;
        private final long lockWaitTime;
        private final List<RLock> acquiredLocks;
        private final long waitTime;
        private final long threadId;
        private final long leaseTime;
        private final TimeUnit unit;
        private long remainTime;
        private long time = System.currentTimeMillis();
        private int failedLocksLimit;

        LockState(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
            this.waitTime = waitTime;
            this.leaseTime = leaseTime;
            this.unit = unit;
            this.threadId = threadId;
            this.newLeaseTime = leaseTime != -1L ? unit.toMillis(waitTime) * 2L : -1L;
            this.remainTime = -1L;
            if (waitTime != -1L) {
                this.remainTime = unit.toMillis(waitTime);
            }
            this.lockWaitTime = RedissonMultiLock.this.calcLockWaitTime(this.remainTime);
            this.failedLocksLimit = RedissonMultiLock.this.failedLocksLimit();
            this.acquiredLocks = new ArrayList<RLock>(RedissonMultiLock.this.locks.size());
        }

        void tryAcquireLockAsync(ListIterator<RLock> iterator, RPromise<Boolean> result) {
            if (!iterator.hasNext()) {
                this.checkLeaseTimeAsync(result);
                return;
            }
            RLock lock = iterator.next();
            RedissonPromise lockAcquiredFuture = new RedissonPromise();
            if (this.waitTime == -1L && this.leaseTime == -1L) {
                lock.tryLockAsync(this.threadId).onComplete(new TransferListener(lockAcquiredFuture));
            } else {
                long awaitTime = Math.min(this.lockWaitTime, this.remainTime);
                lock.tryLockAsync(awaitTime, this.newLeaseTime, TimeUnit.MILLISECONDS, this.threadId).onComplete(new TransferListener(lockAcquiredFuture));
            }
            lockAcquiredFuture.onComplete((res, e) -> {
                boolean lockAcquired = false;
                if (res != null) {
                    lockAcquired = res;
                }
                if (e instanceof RedisResponseTimeoutException) {
                    RedissonMultiLock.this.unlockInnerAsync(Arrays.asList(lock), this.threadId);
                }
                if (lockAcquired) {
                    this.acquiredLocks.add(lock);
                } else {
                    if (RedissonMultiLock.this.locks.size() - this.acquiredLocks.size() == RedissonMultiLock.this.failedLocksLimit()) {
                        this.checkLeaseTimeAsync(result);
                        return;
                    }
                    if (this.failedLocksLimit == 0) {
                        RedissonMultiLock.this.unlockInnerAsync(this.acquiredLocks, this.threadId).onComplete((r, ex) -> {
                            if (ex != null) {
                                result.tryFailure((Throwable)ex);
                                return;
                            }
                            if (this.waitTime == -1L && this.leaseTime == -1L) {
                                result.trySuccess(false);
                                return;
                            }
                            this.failedLocksLimit = RedissonMultiLock.this.failedLocksLimit();
                            this.acquiredLocks.clear();
                            while (iterator.hasPrevious()) {
                                iterator.previous();
                            }
                            this.checkRemainTimeAsync(iterator, result);
                        });
                        return;
                    }
                    --this.failedLocksLimit;
                }
                this.checkRemainTimeAsync(iterator, result);
            });
        }

        private void checkLeaseTimeAsync(RPromise<Boolean> result) {
            if (this.leaseTime != -1L) {
                AtomicInteger counter = new AtomicInteger(this.acquiredLocks.size());
                for (RLock rLock : this.acquiredLocks) {
                    RFuture future = ((RedissonLock)rLock).expireAsync(this.unit.toMillis(this.leaseTime), TimeUnit.MILLISECONDS);
                    future.onComplete((res, e) -> {
                        if (e != null) {
                            result.tryFailure((Throwable)e);
                            return;
                        }
                        if (counter.decrementAndGet() == 0) {
                            result.trySuccess(true);
                        }
                    });
                }
                return;
            }
            result.trySuccess(true);
        }

        private void checkRemainTimeAsync(ListIterator<RLock> iterator, RPromise<Boolean> result) {
            if (this.remainTime != -1L) {
                this.remainTime += -(System.currentTimeMillis() - this.time);
                this.time = System.currentTimeMillis();
                if (this.remainTime <= 0L) {
                    RedissonMultiLock.this.unlockInnerAsync(this.acquiredLocks, this.threadId).onComplete((res, e) -> {
                        if (e != null) {
                            result.tryFailure((Throwable)e);
                            return;
                        }
                        result.trySuccess(false);
                    });
                    return;
                }
            }
            this.tryAcquireLockAsync(iterator, result);
        }
    }
}

