/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.session;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RMap;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.PatternMessageListener;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.CompositeCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;

public class RedissonSessionRepository
implements FindByIndexNameSessionRepository<RedissonSession>,
PatternMessageListener<String> {
    private static final Logger log = LoggerFactory.getLogger(RedissonSessionRepository.class);
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private RedissonClient redisson;
    private ApplicationEventPublisher eventPublisher;
    private RPatternTopic deletedTopic;
    private RPatternTopic expiredTopic;
    private RPatternTopic createdTopic;
    private String keyPrefix = "spring:session:";
    private Integer defaultMaxInactiveInterval;

    public RedissonSessionRepository(RedissonClient redissonClient, ApplicationEventPublisher eventPublisher) {
        this.redisson = redissonClient;
        this.eventPublisher = eventPublisher;
        this.deletedTopic = this.redisson.getPatternTopic("__keyevent@*:del", StringCodec.INSTANCE);
        this.deletedTopic.addListener(String.class, this);
        this.expiredTopic = this.redisson.getPatternTopic("__keyevent@*:expired", StringCodec.INSTANCE);
        this.expiredTopic.addListener(String.class, this);
        this.createdTopic = this.redisson.getPatternTopic(this.getEventsChannelPrefix() + "*", StringCodec.INSTANCE);
        this.createdTopic.addListener(String.class, this);
    }

    @Override
    public void onMessage(CharSequence pattern, CharSequence channel, String body) {
        if (this.createdTopic.getPatternNames().contains(pattern.toString())) {
            RedissonSession session = this.findById(body);
            if (session != null) {
                this.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)session));
            }
        } else if (this.deletedTopic.getPatternNames().contains(pattern.toString())) {
            if (!body.startsWith(this.keyPrefix)) {
                return;
            }
            String id = body.split(this.keyPrefix)[1];
            RedissonSession session = new RedissonSession(id);
            if (session.load()) {
                session.clearPrincipal();
            }
            this.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)session));
        } else if (this.expiredTopic.getPatternNames().contains(pattern.toString())) {
            if (!body.startsWith(this.keyPrefix)) {
                return;
            }
            String id = body.split(this.keyPrefix)[1];
            RedissonSession session = new RedissonSession(id);
            if (session.load()) {
                session.clearPrincipal();
            }
            this.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)session));
        }
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public RedissonSession createSession() {
        RedissonSession session = new RedissonSession();
        if (this.defaultMaxInactiveInterval != null) {
            session.setMaxInactiveInterval(Duration.ofSeconds(this.defaultMaxInactiveInterval.intValue()));
        }
        return session;
    }

    public void save(RedissonSession session) {
    }

    public RedissonSession findById(String id) {
        RedissonSession session = new RedissonSession(id);
        if (!session.load() || session.isExpired()) {
            return null;
        }
        return session;
    }

    public void deleteById(String id) {
        RedissonSession session = this.findById(id);
        if (session == null) {
            return;
        }
        session.clearPrincipal();
        session.delete();
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    String resolvePrincipal(Session session) {
        String principalName = (String)session.getAttribute(PRINCIPAL_NAME_INDEX_NAME);
        if (principalName != null) {
            return principalName;
        }
        Object auth = session.getAttribute(SPRING_SECURITY_CONTEXT);
        if (auth == null) {
            return null;
        }
        Expression expression = SPEL_PARSER.parseExpression("authentication?.name");
        return (String)expression.getValue(auth, String.class);
    }

    String getEventsChannelName(String sessionId) {
        return this.getEventsChannelPrefix() + sessionId;
    }

    String getEventsChannelPrefix() {
        return this.keyPrefix + "created:event:";
    }

    String getPrincipalKey(String principalName) {
        return this.keyPrefix + "index:" + FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME + ":" + principalName;
    }

    String getSessionAttrNameKey(String name) {
        return "session-attr:" + name;
    }

    public Map<String, RedissonSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        RSet<String> set = this.getPrincipalSet(indexValue);
        Set<String> sessionIds = set.readAll();
        HashMap<String, RedissonSession> result = new HashMap<String, RedissonSession>();
        for (String id : sessionIds) {
            RedissonSession session = this.findById(id);
            if (session == null) continue;
            result.put(id, session);
        }
        return result;
    }

    private RSet<String> getPrincipalSet(String indexValue) {
        String principalKey = this.getPrincipalKey(indexValue);
        return this.redisson.getSet(principalKey, StringCodec.INSTANCE);
    }

    final class RedissonSession
    implements Session {
        private String principalName;
        private final MapSession delegate;
        private RMap<String, Object> map;

        RedissonSession() {
            this.delegate = new MapSession();
            this.map = RedissonSessionRepository.this.redisson.getMap(RedissonSessionRepository.this.keyPrefix + this.delegate.getId(), new CompositeCodec(StringCodec.INSTANCE, RedissonSessionRepository.this.redisson.getConfig().getCodec()));
            this.principalName = RedissonSessionRepository.this.resolvePrincipal((Session)this.delegate);
            HashMap<String, Long> newMap = new HashMap<String, Long>(3);
            newMap.put("session:creationTime", this.delegate.getCreationTime().toEpochMilli());
            newMap.put("session:lastAccessedTime", this.delegate.getLastAccessedTime().toEpochMilli());
            newMap.put("session:maxInactiveInterval", this.delegate.getMaxInactiveInterval().getSeconds());
            this.map.putAll(newMap);
            this.updateExpiration();
            String channelName = RedissonSessionRepository.this.getEventsChannelName(this.delegate.getId());
            RTopic topic = RedissonSessionRepository.this.redisson.getTopic(channelName, StringCodec.INSTANCE);
            topic.publish(this.delegate.getId());
        }

        private void updateExpiration() {
            if (this.delegate.getMaxInactiveInterval().getSeconds() >= 0L) {
                this.map.expire(this.delegate.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
            }
        }

        RedissonSession(String sessionId) {
            this.delegate = new MapSession(sessionId);
            this.map = RedissonSessionRepository.this.redisson.getMap(RedissonSessionRepository.this.keyPrefix + sessionId, new CompositeCodec(StringCodec.INSTANCE, RedissonSessionRepository.this.redisson.getConfig().getCodec()));
            this.principalName = RedissonSessionRepository.this.resolvePrincipal((Session)this.delegate);
        }

        public void delete() {
            this.map.delete();
        }

        public boolean load() {
            Set<Map.Entry<String, Object>> entrySet = this.map.readAllEntrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                if ("session:creationTime".equals(entry.getKey())) {
                    this.delegate.setCreationTime(Instant.ofEpochMilli((Long)entry.getValue()));
                    continue;
                }
                if ("session:lastAccessedTime".equals(entry.getKey())) {
                    this.delegate.setLastAccessedTime(Instant.ofEpochMilli((Long)entry.getValue()));
                    continue;
                }
                if ("session:maxInactiveInterval".equals(entry.getKey())) {
                    this.delegate.setMaxInactiveInterval(Duration.ofSeconds((Long)entry.getValue()));
                    continue;
                }
                this.delegate.setAttribute(entry.getKey(), entry.getValue());
            }
            return !entrySet.isEmpty();
        }

        public String getId() {
            return this.delegate.getId();
        }

        public <T> T getAttribute(String attributeName) {
            return (T)this.delegate.getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            if (attributeValue == null) {
                this.removeAttribute(attributeName);
                return;
            }
            this.delegate.setAttribute(attributeName, attributeValue);
            if (this.map != null) {
                this.map.fastPut(attributeName, attributeValue);
                String principalSessionAttr = RedissonSessionRepository.this.getSessionAttrNameKey(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
                String securityPrincipalSessionAttr = RedissonSessionRepository.this.getSessionAttrNameKey(RedissonSessionRepository.SPRING_SECURITY_CONTEXT);
                if (attributeName.equals(principalSessionAttr) || attributeName.equals(securityPrincipalSessionAttr)) {
                    RSet set;
                    if (this.principalName != null) {
                        set = RedissonSessionRepository.this.getPrincipalSet(this.principalName);
                        set.remove(this.getId());
                    }
                    this.principalName = RedissonSessionRepository.this.resolvePrincipal(this);
                    if (this.principalName != null) {
                        set = RedissonSessionRepository.this.getPrincipalSet(this.principalName);
                        set.add(this.getId());
                    }
                }
            }
        }

        public void clearPrincipal() {
            this.principalName = RedissonSessionRepository.this.resolvePrincipal(this);
            if (this.principalName != null) {
                RSet set = RedissonSessionRepository.this.getPrincipalSet(this.principalName);
                set.remove(this.getId());
            }
        }

        public void removeAttribute(String attributeName) {
            this.delegate.removeAttribute(attributeName);
            if (this.map != null) {
                this.map.fastRemove((String[])new String[]{attributeName});
            }
        }

        public Instant getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            if (this.map != null) {
                this.map.fastPut("session:lastAccessedTime", lastAccessedTime.toEpochMilli());
                this.updateExpiration();
            }
        }

        public Instant getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.delegate.setMaxInactiveInterval(interval);
            if (this.map != null) {
                this.map.fastPut("session:maxInactiveInterval", interval.getSeconds());
                this.updateExpiration();
            }
        }

        public Duration getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.delegate.isExpired();
        }

        public String changeSessionId() {
            String id = this.delegate.changeSessionId();
            if (RedissonSessionRepository.this.redisson.getConfig().isClusterConfig()) {
                Map<String, Object> oldState = this.map.readAllMap();
                this.map.delete();
                this.map = RedissonSessionRepository.this.redisson.getMap(RedissonSessionRepository.this.keyPrefix + id, this.map.getCodec());
                this.map.putAll(oldState);
            } else {
                this.map.rename(RedissonSessionRepository.this.keyPrefix + id);
            }
            return id;
        }
    }
}

