/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.MapWriterTask;
import org.redisson.api.MapOptions;
import org.redisson.command.CommandAsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWriteBehindTask {
    private static final Logger log = LoggerFactory.getLogger(MapWriteBehindTask.class);
    private final AtomicBoolean isScheduled = new AtomicBoolean();
    private final Queue<MapWriterTask> writeBehindTasks = new ConcurrentLinkedQueue<MapWriterTask>();
    private final CommandAsyncExecutor commandExecutor;
    private final MapOptions<Object, Object> options;

    public MapWriteBehindTask(CommandAsyncExecutor commandExecutor, MapOptions<?, ?> options) {
        this.commandExecutor = commandExecutor;
        this.options = options;
    }

    private void enqueueTask() {
        if (!this.isScheduled.compareAndSet(false, true)) {
            return;
        }
        this.commandExecutor.getConnectionManager().newTimeout(t -> this.commandExecutor.getConnectionManager().getExecutor().execute(this::lambda$null$0), this.options.getWriteBehindDelay(), TimeUnit.MILLISECONDS);
    }

    public void addTask(MapWriterTask task) {
        this.writeBehindTasks.add(task);
        this.enqueueTask();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$null$0() {
        addedMap = new LinkedHashMap<K, V>();
        deletedKeys = new ArrayList<Object>();
lbl3:
        // 3 sources

        try {
            while ((task = this.writeBehindTasks.poll()) != null) {
                block8: {
                    if (!(task instanceof MapWriterTask.Remove)) break block8;
                    for (Object key : task.getKeys()) {
                        deletedKeys.add(key);
                        if (deletedKeys.size() != this.options.getWriteBehindBatchSize()) continue;
                        this.options.getWriter().delete(deletedKeys);
                        deletedKeys.clear();
                    }
                    ** GOTO lbl3
                }
                for (Map.Entry entry : task.getMap().entrySet()) {
                    addedMap.put(entry.getKey(), entry.getValue());
                    if (addedMap.size() != this.options.getWriteBehindBatchSize()) continue;
                    this.options.getWriter().write(addedMap);
                    addedMap.clear();
                }
                ** GOTO lbl3
            }
            if (!deletedKeys.isEmpty()) {
                this.options.getWriter().delete(deletedKeys);
                deletedKeys.clear();
            }
            if (!addedMap.isEmpty()) {
                this.options.getWriter().write(addedMap);
                addedMap.clear();
            }
        }
        catch (Exception e) {
            MapWriteBehindTask.log.error(e.getMessage(), (Throwable)e);
        }
        this.isScheduled.set(false);
        if (!this.writeBehindTasks.isEmpty()) {
            this.enqueueTask();
        }
    }
}

