/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.WorkerOptions;
import org.redisson.client.RedisConnection;
import org.redisson.config.RedissonNodeConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedissonNode {
    private static final Logger log = LoggerFactory.getLogger(RedissonNode.class);
    private boolean hasRedissonInstance;
    private RedissonClient redisson;
    private final RedissonNodeConfig config;
    private final String id;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress;

    private RedissonNode(RedissonNodeConfig config, RedissonClient redisson) {
        this.config = new RedissonNodeConfig(config);
        this.id = this.generateId();
        this.redisson = redisson;
        this.hasRedissonInstance = redisson == null;
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getId() {
        return this.id;
    }

    private String generateId() {
        byte[] id = new byte[8];
        ThreadLocalRandom.current().nextBytes(id);
        return ByteBufUtil.hexDump((byte[])id);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Config file not defined");
        }
        String configPath = args[0];
        RedissonNodeConfig config = null;
        try {
            config = RedissonNodeConfig.fromJSON(new File(configPath));
        }
        catch (IOException e) {
            try {
                config = RedissonNodeConfig.fromYAML(new File(configPath));
            }
            catch (IOException e1) {
                log.error("Can't parse json config " + configPath, (Throwable)e);
                throw new IllegalArgumentException("Can't parse yaml config " + configPath, e1);
            }
        }
        final RedissonNode node = RedissonNode.create(config);
        node.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                node.shutdown();
            }
        });
    }

    public void shutdown() {
        if (this.hasRedissonInstance) {
            this.redisson.shutdown(0L, 15L, TimeUnit.MINUTES);
            log.info("Redisson node has been shutdown successfully");
        }
    }

    public void start() {
        int mapReduceWorkers;
        if (this.hasRedissonInstance) {
            this.redisson = Redisson.create(this.config);
        }
        this.retrieveAddresses();
        if (this.config.getRedissonNodeInitializer() != null) {
            this.config.getRedissonNodeInitializer().onStartup(this);
        }
        if ((mapReduceWorkers = this.config.getMapReduceWorkers()) != -1) {
            if (mapReduceWorkers == 0) {
                mapReduceWorkers = Runtime.getRuntime().availableProcessors();
            }
            WorkerOptions options = WorkerOptions.defaults().workers(mapReduceWorkers).beanFactory(this.config.getBeanFactory());
            this.redisson.getExecutorService("redisson_mapreduce").registerWorkers(options);
            log.info("{} map reduce worker(s) registered", (Object)mapReduceWorkers);
        }
        for (Map.Entry<String, Integer> entry : this.config.getExecutorServiceWorkers().entrySet()) {
            String name = entry.getKey();
            int workers = entry.getValue();
            WorkerOptions options = WorkerOptions.defaults().workers(workers).beanFactory(this.config.getBeanFactory());
            this.redisson.getExecutorService(name).registerWorkers(options);
            log.info("{} worker(s) registered for ExecutorService with '{}' name", (Object)workers, (Object)name);
        }
        log.info("Redisson node started!");
    }

    private void retrieveAddresses() {
        ConnectionManager connectionManager = ((Redisson)this.redisson).getConnectionManager();
        for (MasterSlaveEntry entry : connectionManager.getEntrySet()) {
            RFuture<RedisConnection> readFuture = entry.connectionReadOp(null);
            if (readFuture.awaitUninterruptibly(connectionManager.getConfig().getConnectTimeout()) && readFuture.isSuccess()) {
                RedisConnection connection = readFuture.getNow();
                entry.releaseRead(connection);
                this.remoteAddress = (InetSocketAddress)connection.getChannel().remoteAddress();
                this.localAddress = (InetSocketAddress)connection.getChannel().localAddress();
                return;
            }
            RFuture<RedisConnection> writeFuture = entry.connectionWriteOp(null);
            if (!writeFuture.awaitUninterruptibly(connectionManager.getConfig().getConnectTimeout()) || !writeFuture.isSuccess()) continue;
            RedisConnection connection = writeFuture.getNow();
            entry.releaseWrite(connection);
            this.remoteAddress = (InetSocketAddress)connection.getChannel().remoteAddress();
            this.localAddress = (InetSocketAddress)connection.getChannel().localAddress();
            return;
        }
    }

    public static RedissonNode create(RedissonNodeConfig config) {
        return RedissonNode.create(config, null);
    }

    public static RedissonNode create(RedissonNodeConfig config, RedissonClient redisson) {
        return new RedissonNode(config, redisson);
    }
}

