/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import org.redisson.RedissonCountDownLatchEntry;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.PublishSubscribe;
import org.redisson.pubsub.PublishSubscribeService;

public class CountDownLatchPubSub
extends PublishSubscribe<RedissonCountDownLatchEntry> {
    public static final Long ZERO_COUNT_MESSAGE = 0L;
    public static final Long NEW_COUNT_MESSAGE = 1L;

    public CountDownLatchPubSub(PublishSubscribeService service) {
        super(service);
    }

    @Override
    protected RedissonCountDownLatchEntry createEntry(RPromise<RedissonCountDownLatchEntry> newPromise) {
        return new RedissonCountDownLatchEntry(newPromise);
    }

    @Override
    protected void onMessage(RedissonCountDownLatchEntry value, Long message) {
        if (message.equals(ZERO_COUNT_MESSAGE)) {
            value.getLatch().open();
        }
        if (message.equals(NEW_COUNT_MESSAGE)) {
            value.getLatch().close();
        }
    }
}

