/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonLock;
import org.redisson.RedissonMultiMapIterator;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonSemaphore;
import org.redisson.ScanResult;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMultimap;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.iterator.RedissonBaseMapIterator;
import org.redisson.misc.Hash;
import org.redisson.misc.RedissonPromise;

public abstract class RedissonMultimap<K, V>
extends RedissonExpirable
implements RMultimap<K, V> {
    final String prefix = RedissonMultimap.suffixName(this.getName(), "");

    RedissonMultimap(CommandAsyncExecutor commandAsyncExecutor, String name) {
        super(commandAsyncExecutor, name);
    }

    RedissonMultimap(Codec codec, CommandAsyncExecutor commandAsyncExecutor, String name) {
        super(codec, commandAsyncExecutor, name);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_LONG, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[1] .. v; size = size + redis.call('memory', 'usage', name); end;end; return size; ", Arrays.asList(this.getName()), this.prefix);
    }

    @Override
    public RLock getFairLock(K key) {
        String lockName = this.getLockByMapKey(key, "fairlock");
        return new RedissonFairLock(this.commandExecutor, lockName);
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(K key) {
        String lockName = this.getLockByMapKey(key, "permitexpirablesemaphore");
        return new RedissonPermitExpirableSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RCountDownLatch getCountDownLatch(K key) {
        String lockName = this.getLockByMapKey(key, "countdownlatch");
        return new RedissonCountDownLatch(this.commandExecutor, lockName);
    }

    @Override
    public RSemaphore getSemaphore(K key) {
        String lockName = this.getLockByMapKey(key, "semaphore");
        return new RedissonSemaphore(this.commandExecutor, lockName);
    }

    @Override
    public RLock getLock(K key) {
        String lockName = this.getLockByMapKey(key, "lock");
        return new RedissonLock(this.commandExecutor, lockName);
    }

    @Override
    public RReadWriteLock getReadWriteLock(K key) {
        String lockName = this.getLockByMapKey(key, "rw_lock");
        return new RedissonReadWriteLock(this.commandExecutor, lockName);
    }

    protected String hash(ByteBuf objectState) {
        return Hash.hash128toBase64(objectState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String keyHash(Object key) {
        ByteBuf objectState = this.encodeMapKey(key);
        try {
            String string = Hash.hash128toBase64(objectState);
            return string;
        }
        finally {
            objectState.release();
        }
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public int keySize() {
        return this.get(this.keySizeAsync());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(this.containsKeyAsync(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get(this.containsValueAsync(value));
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.get(this.containsEntryAsync(key, value));
    }

    @Override
    public boolean put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    String getValuesName(String hash) {
        return RedissonMultimap.suffixName(this.getName(), hash);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.get(this.removeAsync(key, value));
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        return this.get(this.putAllAsync(key, values));
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Collection<V> getAll(K key) {
        return this.get(this.getAllAsync(key));
    }

    @Override
    public Collection<V> removeAll(Object key) {
        return this.get(this.removeAllAsync(key));
    }

    @Override
    public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
        return this.get(this.replaceValuesAsync(key, values));
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return new EntrySet();
    }

    @Override
    public Set<K> readAllKeySet() {
        return this.get(this.readAllKeySetAsync());
    }

    @Override
    public RFuture<Set<K>> readAllKeySetAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.HKEYS, this.getName());
    }

    @Override
    public long fastRemove(K ... keys) {
        return this.get(this.fastRemoveAsync(keys));
    }

    @Override
    public RFuture<Long> fastRemoveAsync(K ... keys) {
        if (keys == null || keys.length == 0) {
            return RedissonPromise.newSucceededFuture(0L);
        }
        ArrayList<Object> mapKeys = new ArrayList<Object>(keys.length);
        ArrayList<Object> listKeys = new ArrayList<Object>(keys.length + 1);
        listKeys.add(this.getName());
        for (K key : keys) {
            ByteBuf keyState = this.encodeMapKey(key);
            mapKeys.add(keyState);
            String keyHash = this.hash(keyState);
            String name = this.getValuesName(keyHash);
            listKeys.add(name);
        }
        return this.fastRemoveAsync((List<Object>)mapKeys, (List<Object>)listKeys, RedisCommands.EVAL_LONG);
    }

    protected <T> RFuture<T> fastRemoveAsync(List<Object> mapKeys, List<Object> listKeys, RedisCommand<T> evalCommandType) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, evalCommandType, "local res = redis.call('hdel', KEYS[1], unpack(ARGV)); if res > 0 then redis.call('del', unpack(KEYS, 2, #KEYS)); end; return res; ", listKeys, mapKeys.toArray());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN_AMOUNT, "local entries = redis.call('hgetall', KEYS[1]); local keys = {KEYS[1]}; for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[1] .. v; table.insert(keys, name); end;end; local n = 0 for i=1, #keys,5000 do n = n + redis.call('del', unpack(keys, i, math.min(i+4999, table.getn(keys)))) end; return n;", Arrays.asList(this.getName()), this.prefix);
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        String newPrefix = RedissonMultimap.suffixName(newName, "");
        RFuture<Void> f = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local entries = redis.call('hgetall', KEYS[1]); local keys = {}; for i, v in ipairs(entries) do if i % 2 == 0 then table.insert(keys, v); end;end; redis.call('rename', KEYS[1], ARGV[3]); for i=1, #keys, 1 do redis.call('rename', ARGV[1] .. keys[i], ARGV[2] .. keys[i]); end; ", Arrays.asList(this.getName()), this.prefix, newPrefix, newName);
        f.onComplete((r, e) -> {
            if (e == null) {
                this.setName(newName);
            }
        });
        return f;
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        String newPrefix = RedissonMultimap.suffixName(newName, "");
        RFuture<Boolean> f = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); local keys = {}; for i, v in ipairs(entries) do if i % 2 == 0 then table.insert(keys, v); end;end; local r = redis.call('exists', ARGV[3]);if r == 1 then return 0;end; for i=1, #keys, 1 do local r = redis.call('exists', ARGV[2] .. keys[i]);if r == 1 then return 0;end; end; redis.call('rename', KEYS[1], ARGV[3]); for i=1, #keys, 1 do redis.call('rename', ARGV[1] .. keys[i], ARGV[2] .. keys[i]); end; return 1; ", Arrays.asList(this.getName()), this.prefix, newPrefix, newName);
        f.onComplete((value, e) -> {
            if (e == null && value.booleanValue()) {
                this.setName(newName);
            }
        });
        return f;
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[2] .. v; redis.call('pexpire', name, ARGV[1]); end;end; return redis.call('pexpire', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName()), timeUnit.toMillis(timeToLive), this.prefix);
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[2] .. v; redis.call('pexpireat', name, ARGV[1]); end;end; return redis.call('pexpireat', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName()), timestamp, this.prefix);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local entries = redis.call('hgetall', KEYS[1]); for i, v in ipairs(entries) do if i % 2 == 0 then local name = ARGV[1] .. v; redis.call('persist', name); end;end; return redis.call('persist', KEYS[1]); ", Arrays.asList(this.getName()), this.prefix);
    }

    @Override
    public RFuture<Integer> keySizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HLEN, this.getName());
    }

    MapScanResult<Object, Object> scanIterator(RedisClient client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, this.getName(), (Codec)new CompositeCodec(this.codec, StringCodec.INSTANCE, this.codec), RedisCommands.HSCAN, this.getName(), startPos);
        return (MapScanResult)this.get(f);
    }

    abstract Iterator<V> valuesIterator();

    abstract RedissonMultiMapIterator<K, V, Map.Entry<K, V>> entryIterator();

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return RedissonMultimap.this.entryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RedissonMultimap.this.containsEntry(e.getKey(), e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return RedissonMultimap.this.remove(key, value);
            }
            return false;
        }

        @Override
        public int size() {
            return RedissonMultimap.this.size();
        }

        @Override
        public void clear() {
            RedissonMultimap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return RedissonMultimap.this.valuesIterator();
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMultimap.this.containsValue(o);
        }

        @Override
        public int size() {
            return RedissonMultimap.this.size();
        }

        @Override
        public void clear() {
            RedissonMultimap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new RedissonBaseMapIterator<K>(){

                @Override
                protected K getValue(Map.Entry<Object, Object> entry) {
                    return entry.getKey();
                }

                @Override
                protected Object put(Map.Entry<Object, Object> entry, Object value) {
                    return RedissonMultimap.this.put(entry.getKey(), value);
                }

                @Override
                protected ScanResult<Map.Entry<Object, Object>> iterator(RedisClient client, long nextIterPos) {
                    return RedissonMultimap.this.scanIterator(client, nextIterPos);
                }

                @Override
                protected void remove(Map.Entry<Object, Object> value) {
                    RedissonMultimap.this.fastRemove(value.getKey());
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return RedissonMultimap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RedissonMultimap.this.fastRemove(o) == 1L;
        }

        @Override
        public int size() {
            return RedissonMultimap.this.keySize();
        }

        @Override
        public void clear() {
            RedissonMultimap.this.clear();
        }
    }
}

