/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Timer timer;
    private final Bootstrap bootstrap;
    private final ChannelGroup channels;
    private static final int BACKOFF_CAP = 12;

    public ConnectionWatchdog(Bootstrap bootstrap, ChannelGroup channels, Timer timer) {
        this.bootstrap = bootstrap;
        this.channels = channels;
        this.timer = timer;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channels.add((Object)ctx.channel());
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Object connection = RedisConnection.getFrom(ctx.channel());
        if (connection != null) {
            ((RedisConnection)connection).fireDisconnected();
            if (!((RedisConnection)connection).isClosed()) {
                if (((RedisConnection)connection).isFastReconnect()) {
                    this.tryReconnect((RedisConnection)connection, 1);
                } else {
                    this.reconnect((RedisConnection)connection, 1);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    private void reconnect(final RedisConnection connection, final int attempts) {
        int timeout = 2 << attempts;
        if (this.bootstrap.config().group().isShuttingDown()) {
            return;
        }
        try {
            this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    ConnectionWatchdog.this.tryReconnect(connection, Math.min(12, attempts + 1));
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void tryReconnect(final RedisConnection connection, final int nextAttempt) {
        if (connection.isClosed() || this.bootstrap.config().group().isShuttingDown()) {
            return;
        }
        this.log.debug("reconnecting {} to {} ", (Object)connection, (Object)connection.getRedisClient().getAddr());
        try {
            this.bootstrap.connect((SocketAddress)connection.getRedisClient().getAddr()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (connection.isClosed() || ConnectionWatchdog.this.bootstrap.config().group().isShuttingDown()) {
                        Channel ch;
                        Object con;
                        if (future.isSuccess() && (con = RedisConnection.getFrom(ch = future.channel())) != null) {
                            ((RedisConnection)con).closeAsync();
                        }
                        return;
                    }
                    if (future.isSuccess()) {
                        Channel channel = future.channel();
                        if (channel.localAddress().equals(channel.remoteAddress())) {
                            channel.close();
                            ConnectionWatchdog.this.log.error("local address and remote address are the same! connected to: {}, localAddress: {} remoteAddress: {}", new Object[]{connection.getRedisClient().getAddr(), channel.localAddress(), channel.remoteAddress()});
                        } else {
                            Object c = RedisConnection.getFrom(channel);
                            ((RedisConnection)c).getConnectionPromise().onComplete((res, e) -> {
                                if (e == null) {
                                    ConnectionWatchdog.this.refresh(connection, channel);
                                    if (!connection.isClosed()) {
                                        ConnectionWatchdog.this.log.debug("{} connected to {}, command: {}", new Object[]{connection, connection.getRedisClient().getAddr(), connection.getCurrentCommand()});
                                    } else {
                                        channel.close();
                                    }
                                } else {
                                    channel.close();
                                    ConnectionWatchdog.this.reconnect(connection, nextAttempt);
                                }
                            });
                            return;
                        }
                    }
                    ConnectionWatchdog.this.reconnect(connection, nextAttempt);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void reattachPubSub(RedisConnection connection) {
        if (connection instanceof RedisPubSubConnection) {
            RedisPubSubConnection conn = (RedisPubSubConnection)connection;
            for (Map.Entry<ChannelName, Codec> entry : conn.getChannels().entrySet()) {
                conn.subscribe(entry.getValue(), entry.getKey());
            }
            for (Map.Entry<ChannelName, Codec> entry : conn.getPatternChannels().entrySet()) {
                conn.psubscribe(entry.getValue(), entry.getKey());
            }
        }
    }

    private void refresh(RedisConnection connection, Channel channel) {
        CommandData<?, ?> currentCommand = connection.getCurrentCommand();
        connection.fireConnected();
        connection.updateChannel(channel);
        if (connection.isFastReconnect()) {
            connection.clearFastReconnect();
        }
        this.reattachBlockingQueue(connection, currentCommand);
        this.reattachPubSub(connection);
    }

    private void reattachBlockingQueue(final RedisConnection connection, final CommandData<?, ?> currentCommand) {
        if (currentCommand == null || !currentCommand.isBlockingCommand() || currentCommand.getPromise().isDone()) {
            return;
        }
        ChannelFuture future = connection.send(currentCommand);
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ConnectionWatchdog.this.log.error("Can't reconnect blocking queue by command: {} using connection: {}", (Object)currentCommand, (Object)connection);
                }
            }
        });
    }
}

