/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMap;
import org.redisson.WriteBehindService;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RedissonClient;
import org.redisson.cache.CacheKey;
import org.redisson.cache.CacheValue;
import org.redisson.cache.LocalCacheListener;
import org.redisson.cache.LocalCacheView;
import org.redisson.cache.LocalCachedMapClear;
import org.redisson.cache.LocalCachedMapInvalidate;
import org.redisson.cache.LocalCachedMapUpdate;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.client.protocol.decoder.ObjectMapEntryReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonLocalCachedMap<K, V>
extends RedissonMap<K, V>
implements RLocalCachedMap<K, V> {
    public static final String TOPIC_SUFFIX = "topic";
    public static final String DISABLED_KEYS_SUFFIX = "disabled-keys";
    public static final String DISABLED_ACK_SUFFIX = ":topic";
    private static final RedisCommand<Set<Object>> ALL_VALUES = new RedisCommand<Object>("EVAL", new MapValueDecoder(new ObjectSetReplayDecoder()));
    private static final RedisCommand<Set<Map.Entry<Object, Object>>> ALL_ENTRIES = new RedisCommand<Set<Map.Entry<Object, Object>>>("EVAL", new ObjectMapEntryReplayDecoder());
    private static final RedisCommand<Map<Object, Object>> ALL_MAP = new RedisCommand("EVAL", new ObjectMapReplayDecoder());
    private long cacheUpdateLogTime = TimeUnit.MINUTES.toMillis(10L);
    private byte[] instanceId;
    private ConcurrentMap<CacheKey, CacheValue> cache;
    private int invalidateEntryOnChange;
    private LocalCachedMapOptions.SyncStrategy syncStrategy;
    private LocalCachedMapOptions.StoreMode storeMode;
    private boolean storeCacheMiss;
    private LocalCacheListener listener;
    private LocalCacheView<K, V> localCacheView;

    public RedissonLocalCachedMap(CommandAsyncExecutor commandExecutor, String name, LocalCachedMapOptions<K, V> options, EvictionScheduler evictionScheduler, RedissonClient redisson, WriteBehindService writeBehindService) {
        super(commandExecutor, name, redisson, options, writeBehindService);
        this.init(options, evictionScheduler);
    }

    public RedissonLocalCachedMap(Codec codec, CommandAsyncExecutor connectionManager, String name, LocalCachedMapOptions<K, V> options, EvictionScheduler evictionScheduler, RedissonClient redisson, WriteBehindService writeBehindService) {
        super(codec, connectionManager, name, redisson, options, writeBehindService);
        this.init(options, evictionScheduler);
    }

    private void init(LocalCachedMapOptions<K, V> options, EvictionScheduler evictionScheduler) {
        this.syncStrategy = options.getSyncStrategy();
        this.storeMode = options.getStoreMode();
        this.storeCacheMiss = options.isStoreCacheMiss();
        this.localCacheView = new LocalCacheView(options, this);
        this.cache = this.localCacheView.getCache();
        this.listener = new LocalCacheListener(this.getRawName(), this.commandExecutor, this, this.codec, options, this.cacheUpdateLogTime){

            @Override
            protected void updateCache(ByteBuf keyBuf, ByteBuf valueBuf) throws IOException {
                CacheKey cacheKey = RedissonLocalCachedMap.this.localCacheView.toCacheKey(keyBuf);
                Object key = RedissonLocalCachedMap.this.codec.getMapKeyDecoder().decode(keyBuf, null);
                Object value = RedissonLocalCachedMap.this.codec.getMapValueDecoder().decode(valueBuf, null);
                RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
            }
        };
        this.listener.add(this.cache);
        this.instanceId = this.listener.getInstanceId();
        if (options.getSyncStrategy() != LocalCachedMapOptions.SyncStrategy.NONE) {
            this.invalidateEntryOnChange = 1;
        }
        if (options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD) {
            this.invalidateEntryOnChange = 2;
            evictionScheduler.schedule(this.listener.getUpdatesLogName(), this.cacheUpdateLogTime + TimeUnit.MINUTES.toMillis(1L));
        }
    }

    public LocalCacheView<K, V> getLocalCacheView() {
        return this.localCacheView;
    }

    private void broadcastLocalCacheStore(V value, ByteBuf mapKey, CacheKey cacheKey) {
        if (this.storeMode != LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return;
        }
        if (this.invalidateEntryOnChange != 0) {
            Serializable msg;
            if (this.syncStrategy == LocalCachedMapOptions.SyncStrategy.UPDATE) {
                ByteBuf mapValue = this.encodeMapValue(value);
                msg = new LocalCachedMapUpdate(this.instanceId, mapKey, mapValue);
            } else {
                msg = new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()});
            }
            this.listener.getInvalidationTopic().publishAsync(msg);
        }
        mapKey.release();
    }

    private CacheValue cachePut(CacheKey cacheKey, Object key, Object value) {
        if (this.listener.isDisabled(cacheKey)) {
            return null;
        }
        return this.cache.put(cacheKey, new CacheValue(key, value));
    }

    private CacheValue cachePutIfAbsent(CacheKey cacheKey, Object key, Object value) {
        if (this.listener.isDisabled(cacheKey)) {
            return null;
        }
        return this.cache.putIfAbsent(cacheKey, new CacheValue(key, value));
    }

    private CacheValue cachePutIfExists(CacheKey cacheKey, Object key, Object value) {
        CacheValue v;
        if (this.listener.isDisabled(cacheKey)) {
            return null;
        }
        while ((v = (CacheValue)this.cache.get(cacheKey)) != null) {
            if (!this.cache.replace(cacheKey, v, new CacheValue(key, value))) continue;
            return v;
        }
        return null;
    }

    private CacheValue cacheReplace(CacheKey cacheKey, Object key, Object value) {
        if (this.listener.isDisabled(cacheKey)) {
            return null;
        }
        return this.cache.replace(cacheKey, new CacheValue(key, value));
    }

    private boolean cacheReplace(CacheKey cacheKey, Object key, Object oldValue, Object newValue) {
        if (this.listener.isDisabled(cacheKey)) {
            return false;
        }
        return this.cache.replace(cacheKey, new CacheValue(key, oldValue), new CacheValue(key, newValue));
    }

    private boolean cacheRemove(CacheKey cacheKey, Object key, Object value) {
        if (this.listener.isDisabled(cacheKey)) {
            return false;
        }
        return this.cache.remove(cacheKey, new CacheValue(key, value));
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return new CompletableFutureWrapper<Integer>(this.cache.size());
        }
        return super.sizeAsync();
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        this.checkKey(key);
        CacheKey cacheKey = this.localCacheView.toCacheKey(key);
        CacheValue cacheValue = (CacheValue)this.cache.get(cacheKey);
        if (cacheValue == null) {
            if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
                if (this.hasNoLoader()) {
                    return new CompletableFutureWrapper<Boolean>(false);
                }
                CompletableFuture future = this.loadValue(key, false);
                CompletionStage f = future.thenApply(value -> {
                    if (this.storeCacheMiss || value != null) {
                        this.cachePut(cacheKey, key, value);
                    }
                    return value != null;
                });
                return new CompletableFutureWrapper<Boolean>((CompletableFuture<Boolean>)f);
            }
            CompletableFuture promise = new CompletableFuture();
            promise.thenAccept(value -> {
                if (this.storeCacheMiss || value != null) {
                    this.cachePut(cacheKey, key, value);
                }
            });
            return this.containsKeyAsync(key, promise);
        }
        return new CompletableFutureWrapper<Boolean>(cacheValue.getValue() != null);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        this.checkValue(value);
        CacheValue cacheValue = new CacheValue(null, value);
        if (!this.cache.containsValue(cacheValue)) {
            if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
                return new CompletableFutureWrapper<Boolean>(false);
            }
            return super.containsValueAsync(value);
        }
        return new CompletableFutureWrapper<Boolean>(true);
    }

    @Override
    protected RFuture<V> getAsync(K key, long threadId) {
        this.checkKey(key);
        CacheKey cacheKey = this.localCacheView.toCacheKey(key);
        CacheValue cacheValue = (CacheValue)this.cache.get(cacheKey);
        if (cacheValue != null && (this.storeCacheMiss || cacheValue.getValue() != null)) {
            return new CompletableFutureWrapper<Object>(cacheValue.getValue());
        }
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            if (this.hasNoLoader()) {
                return new CompletableFutureWrapper<Void>((Void)null);
            }
            CompletableFuture future = this.loadValue(key, false, threadId);
            CompletionStage f = future.thenApply(value -> {
                if (this.storeCacheMiss || value != null) {
                    this.cachePut(cacheKey, key, value);
                }
                return value;
            });
            return new CompletableFutureWrapper(f);
        }
        RFuture future = super.getAsync(key, threadId);
        CompletionStage<Object> result = future.thenApply(value -> {
            if (this.storeCacheMiss || value != null) {
                this.cachePut(cacheKey, key, value);
            }
            return value;
        });
        return new CompletableFutureWrapper<Object>(result);
    }

    protected static byte[] generateLogEntryId(byte[] keyHash) {
        byte[] result = new byte[keyHash.length + 1 + 8];
        result[16] = 58;
        byte[] id = new byte[8];
        ThreadLocalRandom.current().nextBytes(id);
        System.arraycopy(keyHash, 0, result, 0, keyHash.length);
        System.arraycopy(id, 0, result, 17, id.length);
        return result;
    }

    @Override
    protected RFuture<V> putOperationAsync(K key, V value) {
        ByteBuf mapKey = this.encodeMapKey(key);
        CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
        CacheValue prevValue = this.cachePut(cacheKey, key, value);
        this.broadcastLocalCacheStore(value, mapKey, cacheKey);
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            Object val = null;
            if (prevValue != null) {
                val = prevValue.getValue();
            }
            return new CompletableFutureWrapper<Object>(val);
        }
        ByteBuf mapValue = this.encodeMapValue(value);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(mapKey, mapValue, cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[3]); end;return v; ", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), mapKey, mapValue, msg, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    protected ByteBuf createSyncMessage(ByteBuf mapKey, ByteBuf mapValue, CacheKey cacheKey) {
        if (this.syncStrategy == LocalCachedMapOptions.SyncStrategy.UPDATE) {
            return this.encode(new LocalCachedMapUpdate(this.instanceId, mapKey, mapValue));
        }
        return this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
    }

    @Override
    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        ByteBuf encodedKey = this.encodeMapKey(key);
        CacheKey cacheKey = this.localCacheView.toCacheKey(encodedKey);
        CacheValue prevValue = this.cachePut(cacheKey, key, value);
        this.broadcastLocalCacheStore(value, encodedKey, cacheKey);
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return new CompletableFutureWrapper<Boolean>(prevValue == null);
        }
        ByteBuf encodedValue = this.encodeMapValue(value);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(encodedKey, encodedValue, cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[3]); end;if redis.call('hset', KEYS[1], ARGV[1], ARGV[2]) == 0 then return 0; end; return 1; ", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), encodedKey, encodedValue, msg, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.cache.clear();
        this.listener.remove();
    }

    @Override
    protected RFuture<V> removeOperationAsync(K key) {
        ByteBuf keyEncoded = this.encodeMapKey(key);
        CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
        CacheValue value = (CacheValue)this.cache.remove(cacheKey);
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            keyEncoded.release();
            LocalCachedMapInvalidate msg = new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()});
            this.listener.getInvalidationTopic().publishAsync(msg);
            Object val = null;
            if (value != null) {
                val = value.getValue();
            }
            return new CompletableFutureWrapper<Object>(val);
        }
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); if redis.call('hdel', KEYS[1], ARGV[1]) == 1 then if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[2]); end; if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[4], ARGV[5]);redis.call('publish', KEYS[2], ARGV[2]); end;end; return v", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyEncoded, msgEncoded, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    @Override
    protected RFuture<List<Long>> fastRemoveOperationBatchAsync(K ... keys) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return new CompletableFutureWrapper<List<Long>>(Collections.emptyList());
        }
        if (this.invalidateEntryOnChange == 1) {
            ArrayList<ByteBuf> params = new ArrayList<ByteBuf>(keys.length * 2);
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
            }
            return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for j = 1, #ARGV, 2 do local val = redis.call('hdel', KEYS[1], ARGV[j]);if val == 1 then redis.call('publish', KEYS[2], ARGV[j+1]); end;table.insert(result, val);end;return result;", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName()), params.toArray());
        }
        if (this.invalidateEntryOnChange == 2) {
            ArrayList<Object> params = new ArrayList<Object>(keys.length * 3);
            params.add(System.currentTimeMillis());
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
                params.add(entryId);
            }
            return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for j = 2, #ARGV, 3 do local val = redis.call('hdel', KEYS[1], ARGV[j]);if val == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[j+2]);redis.call('publish', KEYS[2], ARGV[j+1]); end;table.insert(result, val);end;return result;", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), params.toArray());
        }
        ArrayList<ByteBuf> params = new ArrayList<ByteBuf>(keys.length);
        for (K k : keys) {
            ByteBuf keyEncoded = this.encodeMapKey(k);
            params.add(keyEncoded);
            CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
            this.cache.remove(cacheKey);
        }
        RFuture<List<Long>> future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for i = 1, #ARGV, 1 do local val = redis.call('hdel', KEYS[1], ARGV[i]); table.insert(result, val); end;return result;", Arrays.asList(this.getRawName()), params.toArray());
        return future;
    }

    @Override
    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            long count = 0L;
            for (K k : keys) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(k);
                CacheValue val = (CacheValue)this.cache.remove(cacheKey);
                if (val == null) continue;
                ++count;
                LocalCachedMapInvalidate msg = new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()});
                this.listener.getInvalidationTopic().publishAsync(msg);
            }
            return new CompletableFutureWrapper<Long>(count);
        }
        if (this.invalidateEntryOnChange == 1) {
            ArrayList<ByteBuf> params = new ArrayList<ByteBuf>(keys.length * 2);
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
            }
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "local counter = 0; for j = 1, #ARGV, 2 do if redis.call('hdel', KEYS[1], ARGV[j]) == 1 then redis.call('publish', KEYS[2], ARGV[j+1]); counter = counter + 1;end;end;return counter;", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName()), params.toArray());
        }
        if (this.invalidateEntryOnChange == 2) {
            ArrayList<Object> params = new ArrayList<Object>(keys.length * 3);
            params.add(System.currentTimeMillis());
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
                params.add(entryId);
            }
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "local counter = 0; for j = 2, #ARGV, 3 do if redis.call('hdel', KEYS[1], ARGV[j]) == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[j+2]);redis.call('publish', KEYS[2], ARGV[j+1]); counter = counter + 1;end;end;return counter;", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), params.toArray());
        }
        ArrayList<String> params = new ArrayList<String>(keys.length + 1);
        params.add(this.getRawName());
        for (K k : keys) {
            ByteBuf keyEncoded = this.encodeMapKey(k);
            params.add((String)keyEncoded);
            CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
            this.cache.remove(cacheKey);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.HDEL, params.toArray());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.listener.getUpdatesLogName());
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.cache.clear();
        ByteBuf msgEncoded = this.encode(new LocalCachedMapClear(this.instanceId, this.listener.generateId(), false));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1], KEYS[3]) > 0 and ARGV[2] ~= '0' then redis.call('publish', KEYS[2], ARGV[1]); return 1;end; return 0;", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), msgEncoded, this.invalidateEntryOnChange);
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        if (keys.isEmpty()) {
            return new CompletableFutureWrapper(Collections.emptyMap());
        }
        HashMap result = new HashMap();
        HashSet<K> mapKeys = new HashSet<K>(keys);
        HashSet missedKeys = new HashSet();
        Iterator iterator = mapKeys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            CacheKey cacheKey = this.localCacheView.toCacheKey(key);
            CacheValue value = (CacheValue)this.cache.get(cacheKey);
            if (value != null) {
                if (value.getValue() != null) {
                    result.put(key, value.getValue());
                }
                iterator.remove();
                continue;
            }
            missedKeys.add(key);
        }
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            if (this.hasNoLoader()) {
                return new CompletableFutureWrapper<Map<K, V>>(result);
            }
            if (!missedKeys.isEmpty()) {
                CompletionStage f = this.loadAllMapAsync(missedKeys.spliterator(), false, 1);
                CompletionStage<Map> ff = f.thenApply(map -> {
                    result.putAll(map);
                    return result;
                });
                return new CompletableFutureWrapper<Map<K, V>>(ff);
            }
            return new CompletableFutureWrapper<Map<K, V>>(result);
        }
        RFuture future = super.getAllAsync(missedKeys);
        CompletionStage<Map> f = future.thenApply(map -> {
            result.putAll(map);
            this.cacheMap((Map<?, ?>)map);
            if (this.storeCacheMiss) {
                missedKeys.stream().filter(key -> !map.containsKey(key)).forEach((? super T key) -> {
                    CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                    this.cachePut(cacheKey, key, null);
                });
            }
            return result;
        });
        return new CompletableFutureWrapper<Map<K, V>>(f);
    }

    private void cacheMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            CacheKey cacheKey = this.localCacheView.toCacheKey(entry.getKey());
            this.cachePut(cacheKey, entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> map) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                ByteBuf keyEncoded = this.encodeMapKey(entry.getKey());
                CacheKey cacheKey = this.localCacheView.toCacheKey(keyEncoded);
                this.cachePut(cacheKey, entry.getKey(), entry.getValue());
                this.broadcastLocalCacheStore(entry.getValue(), keyEncoded, cacheKey);
            }
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        ArrayList<Object> params = new ArrayList<Object>(map.size() * 3);
        params.add(this.invalidateEntryOnChange);
        params.add(map.size() * 2);
        byte[][] hashes = new byte[map.size()][];
        int i = 0;
        for (Map.Entry<K, V> t : map.entrySet()) {
            ByteBuf mapKey = this.encodeMapKey(t.getKey());
            ByteBuf mapValue = this.encodeMapValue(t.getValue());
            params.add(mapKey);
            params.add(mapValue);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            hashes[i] = cacheKey.getKeyHash();
            ++i;
        }
        ByteBuf msgEncoded = null;
        if (this.syncStrategy == LocalCachedMapOptions.SyncStrategy.UPDATE) {
            ArrayList<LocalCachedMapUpdate.Entry> entries = new ArrayList<LocalCachedMapUpdate.Entry>();
            for (int j = 2; j < params.size(); j += 2) {
                ByteBuf key = (ByteBuf)params.get(j);
                ByteBuf value = (ByteBuf)params.get(j + 1);
                entries.add(new LocalCachedMapUpdate.Entry(key, value));
            }
            msgEncoded = this.encode(new LocalCachedMapUpdate(this.instanceId, entries));
        } else if (this.syncStrategy == LocalCachedMapOptions.SyncStrategy.INVALIDATE) {
            msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, hashes));
        }
        if (this.invalidateEntryOnChange == 2) {
            long time = System.currentTimeMillis();
            for (byte[] hash : hashes) {
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(hash);
                params.add(time);
                params.add(entryId);
            }
        }
        if (msgEncoded != null) {
            params.add(msgEncoded);
        }
        RFuture future = this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "for i=3, tonumber(ARGV[2]) + 2, 5000 do redis.call('hmset', KEYS[1], unpack(ARGV, i, math.min(i+4999, tonumber(ARGV[2]) + 2))); end; if ARGV[1] == '1' then redis.call('publish', KEYS[2], ARGV[#ARGV]); end;if ARGV[1] == '2' then for i=tonumber(ARGV[2]) + 2 + 1, #ARGV - 1, 5000 do redis.call('zadd', KEYS[3], unpack(ARGV, i, math.min(i+4999, #ARGV - 1))); end; redis.call('publish', KEYS[2], ARGV[#ARGV]); end;", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), params.toArray());
        CompletionStage<Void> f = future.thenApply(res -> {
            this.cacheMap(map);
            return null;
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    protected RFuture<V> addAndGetOperationAsync(K key, Number value) {
        ByteBuf keyState = this.encodeMapKey(key);
        CacheKey cacheKey = this.localCacheView.toCacheKey(keyState);
        ByteBuf msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        RFuture future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("EVAL", new NumberConvertor(value.getClass())), "local result = redis.call('HINCRBYFLOAT', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return result; ", Arrays.asList(this.getRawName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, new BigDecimal(value.toString()).toPlainString(), this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
        CompletionStage<Object> f = future.thenApply(res -> {
            if (res != null) {
                CacheKey cKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cKey, key, res);
            }
            return res;
        });
        return new CompletableFutureWrapper<Object>(f);
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            CacheValue prevValue = this.cachePutIfAbsent(cacheKey, key, value);
            if (prevValue == null) {
                this.broadcastLocalCacheStore(value, mapKey, cacheKey);
                return new CompletableFutureWrapper<Boolean>(true);
            }
            mapKey.release();
            return new CompletableFutureWrapper<Boolean>(false);
        }
        RFuture<Boolean> future = super.fastPutIfAbsentAsync(key, value);
        CompletionStage<Boolean> f = future.thenApply(res -> {
            if (res.booleanValue()) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cacheKey, key, value);
            }
            return res;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<Boolean> fastPutIfExistsAsync(K key, V value) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            CacheValue prevValue = this.cachePutIfExists(cacheKey, key, value);
            if (prevValue != null) {
                this.broadcastLocalCacheStore(value, mapKey, cacheKey);
                return new CompletableFutureWrapper<Boolean>(true);
            }
            mapKey.release();
            return new CompletableFutureWrapper<Boolean>(false);
        }
        RFuture<Boolean> future = super.fastPutIfExistsAsync(key, value);
        CompletionStage<Boolean> f = future.thenApply(res -> {
            if (res.booleanValue()) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cacheKey, key, value);
            }
            return res;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> mapKeys = new ArrayList<Object>();
        for (CacheValue value : this.cache.values()) {
            if (value == null) continue;
            mapKeys.add(this.encodeMapKey(value.getKey(), mapKeys));
            result.add(value.getValue());
        }
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return new CompletableFutureWrapper<Collection<V>>(result);
        }
        RFuture future = this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, ALL_VALUES, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 ~= 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getRawName()), mapKeys.toArray());
        CompletionStage<Collection> f = future.thenApply(res -> {
            result.addAll((Collection<Object>)res);
            return result;
        });
        return new CompletableFutureWrapper<Collection<V>>(f);
    }

    @Override
    public RFuture<Map<K, V>> readAllMapAsync() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        ArrayList<Object> mapKeys = new ArrayList<Object>();
        for (CacheValue value : this.cache.values()) {
            if (value == null) continue;
            mapKeys.add(this.encodeMapKey(value.getKey(), mapKeys));
            result.put(value.getKey(), value.getValue());
        }
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return new CompletableFutureWrapper<Map<K, V>>(result);
        }
        RFuture future = this.readAll(ALL_MAP, mapKeys, result);
        CompletionStage<Map> f = future.thenApply(res -> {
            for (Map.Entry entry : res.entrySet()) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(entry.getKey());
                this.cachePut(cacheKey, entry.getKey(), entry.getValue());
            }
            result.putAll((Map<Object, Object>)res);
            return result;
        });
        return new CompletableFutureWrapper<Map<K, V>>(f);
    }

    @Override
    public void preloadCache() {
        for (Map.Entry entry : super.entrySet()) {
            CacheKey cacheKey = this.localCacheView.toCacheKey(entry.getKey());
            this.cachePut(cacheKey, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void preloadCache(int count) {
        for (Map.Entry entry : super.entrySet(count)) {
            CacheKey cacheKey = this.localCacheView.toCacheKey(entry.getKey());
            this.cachePut(cacheKey, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clearLocalCache() {
        this.get(this.clearLocalCacheAsync());
    }

    @Override
    public RFuture<Void> clearLocalCacheAsync() {
        return this.listener.clearLocalCacheAsync();
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        HashSet<AbstractMap.SimpleEntry<Object, Object>> result = new HashSet<AbstractMap.SimpleEntry<Object, Object>>();
        ArrayList<Object> mapKeys = new ArrayList<Object>();
        for (CacheValue value : this.cache.values()) {
            if (value == null) continue;
            mapKeys.add(this.encodeMapKey(value.getKey(), mapKeys));
            result.add(new AbstractMap.SimpleEntry<Object, Object>(value.getKey(), value.getValue()));
        }
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return new CompletableFutureWrapper<Set<Map.Entry<K, V>>>(result);
        }
        RFuture future = this.readAll(ALL_ENTRIES, mapKeys, result);
        CompletionStage<Set> f = future.thenApply(res -> {
            for (Map.Entry entry : res) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(entry.getKey());
                this.cachePut(cacheKey, entry.getKey(), entry.getValue());
            }
            result.addAll((Collection<AbstractMap.SimpleEntry<Object, Object>>)res);
            return result;
        });
        return new CompletableFutureWrapper<Set<Map.Entry<K, V>>>(f);
    }

    private <R> RFuture<R> readAll(RedisCommand<?> evalCommandType, List<Object> mapKeys, R result) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, evalCommandType, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 ~= 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j]);table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getRawName()), mapKeys.toArray());
    }

    @Override
    public RFuture<Boolean> fastReplaceAsync(K key, V value) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            CacheValue prevValue = this.cacheReplace(cacheKey, key, value);
            if (prevValue != null) {
                this.broadcastLocalCacheStore(value, mapKey, cacheKey);
                return new CompletableFutureWrapper<Boolean>(true);
            }
            mapKey.release();
            return new CompletableFutureWrapper<Boolean>(false);
        }
        RFuture<Boolean> future = super.fastReplaceAsync(key, value);
        CompletionStage<Boolean> f = future.thenApply(res -> {
            if (res.booleanValue()) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cacheKey, key, value);
            }
            return res;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    protected RFuture<Boolean> fastReplaceOperationAsync(K key, V value) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.localCacheView.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(keyState, valueState, cacheKey);
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return 1; else return 0; end", Arrays.asList(name, this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    protected RFuture<V> replaceOperationAsync(K key, V value) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.localCacheView.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(keyState, valueState, cacheKey);
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return v; else return nil; end", Arrays.asList(name, this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<V> replaceAsync(K key, V value) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            CacheValue prevValue = this.cacheReplace(cacheKey, key, value);
            if (prevValue != null) {
                this.broadcastLocalCacheStore(value, mapKey, cacheKey);
                return new CompletableFutureWrapper<Object>(prevValue.getValue());
            }
            mapKey.release();
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        RFuture<V> future = super.replaceAsync(key, value);
        CompletionStage<Object> f = future.thenApply(res -> {
            if (res != null) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cacheKey, key, value);
            }
            return res;
        });
        return new CompletableFutureWrapper<Object>(f);
    }

    @Override
    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf oldValueState = this.encodeMapValue(oldValue);
        ByteBuf newValueState = this.encodeMapValue(newValue);
        CacheKey cacheKey = this.localCacheView.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(keyState, newValueState, cacheKey);
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[5]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[6], ARGV[7]);redis.call('publish', KEYS[2], ARGV[5]); end;return 1; else return 0; end", Arrays.asList(name, this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, oldValueState, newValueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            if (this.cacheReplace(cacheKey, key, oldValue, newValue)) {
                this.broadcastLocalCacheStore(newValue, mapKey, cacheKey);
                return new CompletableFutureWrapper<Boolean>(true);
            }
            mapKey.release();
            return new CompletableFutureWrapper<Boolean>(false);
        }
        RFuture<Boolean> future = super.replaceAsync(key, oldValue, newValue);
        CompletionStage<Boolean> f = future.thenApply(res -> {
            if (res.booleanValue()) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cacheKey, key, newValue);
            }
            return res;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.localCacheView.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Arrays.asList(name, this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            if (this.cacheRemove(cacheKey, key, value)) {
                this.broadcastLocalCacheStore(value, mapKey, cacheKey);
                return new CompletableFutureWrapper<Boolean>(true);
            }
            mapKey.release();
            return new CompletableFutureWrapper<Boolean>(false);
        }
        RFuture<Boolean> future = super.removeAsync(key, value);
        CompletionStage<Boolean> f = future.thenApply(res -> {
            if (res.booleanValue()) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cache.remove(cacheKey);
            }
            return res;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<V> putIfExistsAsync(K key, V value) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            CacheValue prevValue = this.cachePutIfExists(cacheKey, key, value);
            if (prevValue != null) {
                this.broadcastLocalCacheStore(value, mapKey, cacheKey);
                return new CompletableFutureWrapper<Object>(prevValue.getValue());
            }
            mapKey.release();
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        RFuture<V> future = super.putIfExistsAsync(key, value);
        CompletionStage<Object> f = future.thenApply(res -> {
            if (res != null) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cacheKey, key, value);
            }
            return res;
        });
        return new CompletableFutureWrapper<Object>(f);
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            ByteBuf mapKey = this.encodeMapKey(key);
            CacheKey cacheKey = this.localCacheView.toCacheKey(mapKey);
            CacheValue prevValue = this.cachePutIfAbsent(cacheKey, key, value);
            if (prevValue == null) {
                this.broadcastLocalCacheStore(value, mapKey, cacheKey);
                return new CompletableFutureWrapper<Void>((Void)null);
            }
            mapKey.release();
            return new CompletableFutureWrapper<Object>(prevValue.getValue());
        }
        RFuture<V> future = super.putIfAbsentAsync(key, value);
        CompletionStage<Object> f = future.thenApply(res -> {
            if (res == null) {
                CacheKey cacheKey = this.localCacheView.toCacheKey(key);
                this.cachePut(cacheKey, key, value);
            }
            return res;
        });
        return new CompletableFutureWrapper<Object>(f);
    }

    @Override
    public ByteBuf encode(Object value) {
        try {
            return LocalCachedMessageCodec.INSTANCE.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Set<K> cachedKeySet() {
        return this.localCacheView.cachedKeySet();
    }

    @Override
    public Collection<V> cachedValues() {
        return this.localCacheView.cachedValues();
    }

    @Override
    public Set<Map.Entry<K, V>> cachedEntrySet() {
        return this.localCacheView.cachedEntrySet();
    }

    @Override
    public Map<K, V> getCachedMap() {
        return this.localCacheView.getCachedMap();
    }

    @Override
    public Set<K> keySet(String pattern, int count) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return this.cachedKeySet();
        }
        return super.keySet(pattern, count);
    }

    @Override
    public Collection<V> values(String keyPattern, int count) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return this.cachedValues();
        }
        return super.values(keyPattern, count);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(String keyPattern, int count) {
        if (this.storeMode == LocalCachedMapOptions.StoreMode.LOCALCACHE) {
            return this.cachedEntrySet();
        }
        return super.entrySet(keyPattern, count);
    }
}

