/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBinaryStream;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonBuckets;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonDeque;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonFencedLock;
import org.redisson.RedissonFuction;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonIdGenerator;
import org.redisson.RedissonJsonBucket;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonLocalCachedMap;
import org.redisson.RedissonLock;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonObject;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonQueue;
import org.redisson.RedissonRateLimiter;
import org.redisson.RedissonRedLock;
import org.redisson.RedissonReliableTopic;
import org.redisson.RedissonRemoteService;
import org.redisson.RedissonRingBuffer;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSearch;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonSetMultimapCache;
import org.redisson.RedissonShardedTopic;
import org.redisson.RedissonSpinLock;
import org.redisson.RedissonStream;
import org.redisson.RedissonTimeSeries;
import org.redisson.RedissonTopic;
import org.redisson.RedissonTransferQueue;
import org.redisson.WriteBehindService;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNode;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.LockOptions;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDoubleRx;
import org.redisson.api.RAtomicLongRx;
import org.redisson.api.RBatchRx;
import org.redisson.api.RBinaryStreamRx;
import org.redisson.api.RBitSetRx;
import org.redisson.api.RBlockingDequeRx;
import org.redisson.api.RBlockingQueueRx;
import org.redisson.api.RBucketRx;
import org.redisson.api.RBucketsRx;
import org.redisson.api.RCountDownLatchRx;
import org.redisson.api.RDequeRx;
import org.redisson.api.RFencedLockRx;
import org.redisson.api.RFunctionRx;
import org.redisson.api.RGeoRx;
import org.redisson.api.RHyperLogLogRx;
import org.redisson.api.RIdGeneratorRx;
import org.redisson.api.RJsonBucketRx;
import org.redisson.api.RKeysRx;
import org.redisson.api.RLexSortedSetRx;
import org.redisson.api.RListMultimapCacheRx;
import org.redisson.api.RListMultimapRx;
import org.redisson.api.RListRx;
import org.redisson.api.RLocalCachedMapRx;
import org.redisson.api.RLock;
import org.redisson.api.RLockRx;
import org.redisson.api.RMapCacheRx;
import org.redisson.api.RMapRx;
import org.redisson.api.RPatternTopicRx;
import org.redisson.api.RPermitExpirableSemaphoreRx;
import org.redisson.api.RQueueRx;
import org.redisson.api.RRateLimiterRx;
import org.redisson.api.RReadWriteLockRx;
import org.redisson.api.RReliableTopicRx;
import org.redisson.api.RRemoteService;
import org.redisson.api.RRingBufferRx;
import org.redisson.api.RScoredSortedSetRx;
import org.redisson.api.RScriptRx;
import org.redisson.api.RSearchRx;
import org.redisson.api.RSemaphoreRx;
import org.redisson.api.RSetCacheRx;
import org.redisson.api.RSetMultimapCacheRx;
import org.redisson.api.RSetMultimapRx;
import org.redisson.api.RSetRx;
import org.redisson.api.RShardedTopicRx;
import org.redisson.api.RStreamRx;
import org.redisson.api.RTimeSeriesRx;
import org.redisson.api.RTopicRx;
import org.redisson.api.RTransactionRx;
import org.redisson.api.RTransferQueueRx;
import org.redisson.api.RedissonRxClient;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.remote.ResponseEntry;
import org.redisson.rx.CommandRxExecutor;
import org.redisson.rx.CommandRxService;
import org.redisson.rx.RedissonBatchRx;
import org.redisson.rx.RedissonBinaryStreamRx;
import org.redisson.rx.RedissonBlockingDequeRx;
import org.redisson.rx.RedissonBlockingQueueRx;
import org.redisson.rx.RedissonKeysRx;
import org.redisson.rx.RedissonLexSortedSetRx;
import org.redisson.rx.RedissonListMultimapCacheRx;
import org.redisson.rx.RedissonListMultimapRx;
import org.redisson.rx.RedissonListRx;
import org.redisson.rx.RedissonMapCacheRx;
import org.redisson.rx.RedissonMapRx;
import org.redisson.rx.RedissonReadWriteLockRx;
import org.redisson.rx.RedissonScoredSortedSetRx;
import org.redisson.rx.RedissonSetCacheRx;
import org.redisson.rx.RedissonSetMultimapCacheRx;
import org.redisson.rx.RedissonSetMultimapRx;
import org.redisson.rx.RedissonSetRx;
import org.redisson.rx.RedissonTimeSeriesRx;
import org.redisson.rx.RedissonTopicRx;
import org.redisson.rx.RedissonTransactionRx;
import org.redisson.rx.RedissonTransferQueueRx;
import org.redisson.rx.RxProxyBuilder;

public class RedissonRx
implements RedissonRxClient {
    protected final WriteBehindService writeBehindService;
    protected final EvictionScheduler evictionScheduler;
    protected final CommandRxExecutor commandExecutor;
    protected final ConnectionManager connectionManager;
    protected final ConcurrentMap<String, ResponseEntry> responses;

    protected RedissonRx(Config config) {
        Config configCopy = new Config(config);
        this.connectionManager = ConfigSupport.createConnectionManager(configCopy);
        RedissonObjectBuilder objectBuilder = null;
        if (this.connectionManager.getServiceManager().getCfg().isReferenceEnabled()) {
            objectBuilder = new RedissonObjectBuilder(this);
        }
        this.commandExecutor = new CommandRxService(this.connectionManager, objectBuilder);
        this.evictionScheduler = new EvictionScheduler(this.commandExecutor);
        this.writeBehindService = new WriteBehindService(this.commandExecutor);
        this.responses = new ConcurrentHashMap<String, ResponseEntry>();
    }

    protected RedissonRx(ConnectionManager connectionManager, EvictionScheduler evictionScheduler, WriteBehindService writeBehindService, ConcurrentMap<String, ResponseEntry> responses) {
        this.connectionManager = connectionManager;
        RedissonObjectBuilder objectBuilder = null;
        if (connectionManager.getServiceManager().getCfg().isReferenceEnabled()) {
            objectBuilder = new RedissonObjectBuilder(this);
        }
        this.commandExecutor = new CommandRxService(connectionManager, objectBuilder);
        this.evictionScheduler = evictionScheduler;
        this.writeBehindService = writeBehindService;
        this.responses = responses;
    }

    public CommandRxExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public <K, V> RStreamRx<K, V> getStream(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonStream(this.commandExecutor, name), RStreamRx.class);
    }

    @Override
    public <K, V> RStreamRx<K, V> getStream(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonStream(codec, this.commandExecutor, name), RStreamRx.class);
    }

    @Override
    public RSearchRx getSearch() {
        return this.getSearch(null);
    }

    @Override
    public RSearchRx getSearch(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSearch(codec, this.commandExecutor), RSearchRx.class);
    }

    @Override
    public <V> RGeoRx<V> getGeo(String name) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonGeo(this.commandExecutor, name, null), new RedissonScoredSortedSetRx(set), RGeoRx.class);
    }

    @Override
    public <V> RGeoRx<V> getGeo(String name, Codec codec) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonGeo(codec, this.commandExecutor, name, null), new RedissonScoredSortedSetRx(set), RGeoRx.class);
    }

    @Override
    public RLockRx getFairLock(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFairLock(this.commandExecutor, name), RLockRx.class);
    }

    @Override
    public RRateLimiterRx getRateLimiter(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRateLimiter(this.commandExecutor, name), RRateLimiterRx.class);
    }

    @Override
    public RBinaryStreamRx getBinaryStream(String name) {
        RedissonBinaryStream stream = new RedissonBinaryStream(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, stream, new RedissonBinaryStreamRx(this.commandExecutor, stream), RBinaryStreamRx.class);
    }

    @Override
    public RSemaphoreRx getSemaphore(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSemaphore(this.commandExecutor, name), RSemaphoreRx.class);
    }

    @Override
    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPermitExpirableSemaphore(this.commandExecutor, name), RPermitExpirableSemaphoreRx.class);
    }

    @Override
    public RReadWriteLockRx getReadWriteLock(String name) {
        return new RedissonReadWriteLockRx(this.commandExecutor, name);
    }

    @Override
    public RLockRx getLock(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonLock(this.commandExecutor, name), RLockRx.class);
    }

    @Override
    public RLockRx getSpinLock(String name) {
        return this.getSpinLock(name, LockOptions.defaults());
    }

    @Override
    public RLockRx getSpinLock(String name, LockOptions.BackOff backOff) {
        RedissonSpinLock spinLock = new RedissonSpinLock(this.commandExecutor, name, backOff);
        return RxProxyBuilder.create(this.commandExecutor, spinLock, RLockRx.class);
    }

    @Override
    public RFencedLockRx getFencedLock(String name) {
        RedissonFencedLock lock = new RedissonFencedLock(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, lock, RFencedLockRx.class);
    }

    @Override
    public RLockRx getMultiLock(RLockRx ... locks) {
        RLock[] ls = (RLock[])Arrays.stream(locks).map(l -> new RedissonLock(this.commandExecutor, l.getName())).toArray(RLock[]::new);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonMultiLock(ls), RLockRx.class);
    }

    @Override
    public RLockRx getMultiLock(RLock ... locks) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonMultiLock(locks), RLockRx.class);
    }

    @Override
    public RLockRx getRedLock(RLock ... locks) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRedLock(locks), RLockRx.class);
    }

    @Override
    public RCountDownLatchRx getCountDownLatch(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonCountDownLatch(this.commandExecutor, name), RCountDownLatchRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, Codec codec) {
        RedissonMapCache map = new RedissonMapCache(codec, this.evictionScheduler, this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name) {
        RedissonMapCache map = new RedissonMapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBucket(this.commandExecutor, name), RBucketRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBucket(codec, this.commandExecutor, name), RBucketRx.class);
    }

    @Override
    public RBucketsRx getBuckets() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBuckets(this.commandExecutor), RBucketsRx.class);
    }

    @Override
    public RBucketsRx getBuckets(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBuckets(codec, this.commandExecutor), RBucketsRx.class);
    }

    @Override
    public <V> RJsonBucketRx<V> getJsonBucket(String name, JsonCodec<V> codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonJsonBucket<V>(codec, (CommandAsyncExecutor)this.commandExecutor, name), RJsonBucketRx.class);
    }

    @Override
    public <V> RHyperLogLogRx<V> getHyperLogLog(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(this.commandExecutor, name), RHyperLogLogRx.class);
    }

    @Override
    public <V> RHyperLogLogRx<V> getHyperLogLog(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(codec, this.commandExecutor, name), RHyperLogLogRx.class);
    }

    @Override
    public RIdGeneratorRx getIdGenerator(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonIdGenerator(this.commandExecutor, name), RIdGeneratorRx.class);
    }

    @Override
    public <V> RListRx<V> getList(String name) {
        RedissonList list = new RedissonList(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, list, new RedissonListRx(list), RListRx.class);
    }

    @Override
    public <V> RListRx<V> getList(String name, Codec codec) {
        RedissonList list = new RedissonList(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, list, new RedissonListRx(list), RListRx.class);
    }

    @Override
    public <K, V> RListMultimapRx<K, V> getListMultimap(String name) {
        RedissonListMultimap listMultimap = new RedissonListMultimap(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapRx.class);
    }

    @Override
    public <K, V> RListMultimapRx<K, V> getListMultimap(String name, Codec codec) {
        RedissonListMultimap listMultimap = new RedissonListMultimap(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapRx(listMultimap, this.commandExecutor), RListMultimapRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheRx<K, V> getListMultimapCache(String name) {
        RedissonListMultimapCache listMultimap = new RedissonListMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapCacheRx(listMultimap, this.commandExecutor), RListMultimapCacheRx.class);
    }

    @Override
    public <K, V> RListMultimapCacheRx<K, V> getListMultimapCache(String name, Codec codec) {
        RedissonListMultimapCache listMultimap = new RedissonListMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, listMultimap, new RedissonListMultimapCacheRx(listMultimap, this.commandExecutor), RListMultimapCacheRx.class);
    }

    @Override
    public <K, V> RSetMultimapRx<K, V> getSetMultimap(String name) {
        RedissonSetMultimap setMultimap = new RedissonSetMultimap(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapRx.class);
    }

    @Override
    public <K, V> RSetMultimapRx<K, V> getSetMultimap(String name, Codec codec) {
        RedissonSetMultimap setMultimap = new RedissonSetMultimap(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapRx(setMultimap, this.commandExecutor, this), RSetMultimapRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheRx<K, V> getSetMultimapCache(String name) {
        RedissonSetMultimapCache setMultimap = new RedissonSetMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapCacheRx(setMultimap, this.commandExecutor, this), RSetMultimapCacheRx.class);
    }

    @Override
    public <K, V> RSetMultimapCacheRx<K, V> getSetMultimapCache(String name, Codec codec) {
        RedissonSetMultimapCache setMultimap = new RedissonSetMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, setMultimap, new RedissonSetMultimapCacheRx(setMultimap, this.commandExecutor, this), RSetMultimapCacheRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name) {
        RedissonMap map = new RedissonMap(this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, Codec codec) {
        RedissonMap map = new RedissonMap(codec, this.commandExecutor, name, null, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name) {
        RedissonSet set = new RedissonSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetRx(set, this), RSetRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name, Codec codec) {
        RedissonSet set = new RedissonSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetRx(set, this), RSetRx.class);
    }

    @Override
    public <V> RScoredSortedSetRx<V> getScoredSortedSet(String name) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonScoredSortedSetRx(set), RScoredSortedSetRx.class);
    }

    @Override
    public <V> RScoredSortedSetRx<V> getScoredSortedSet(String name, Codec codec) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonScoredSortedSetRx(set), RScoredSortedSetRx.class);
    }

    @Override
    public RLexSortedSetRx getLexSortedSet(String name) {
        RedissonLexSortedSet set = new RedissonLexSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonLexSortedSetRx(set), RLexSortedSetRx.class);
    }

    @Override
    public RShardedTopicRx getShardedTopic(String name) {
        RedissonShardedTopic topic = new RedissonShardedTopic(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RShardedTopicRx.class);
    }

    @Override
    public RShardedTopicRx getShardedTopic(String name, Codec codec) {
        RedissonShardedTopic topic = new RedissonShardedTopic(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RShardedTopicRx.class);
    }

    @Override
    public RTopicRx getTopic(String name) {
        RedissonTopic topic = new RedissonTopic(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RTopicRx.class);
    }

    @Override
    public RTopicRx getTopic(String name, Codec codec) {
        RedissonTopic topic = new RedissonTopic(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RTopicRx.class);
    }

    @Override
    public RReliableTopicRx getReliableTopic(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonReliableTopic(this.commandExecutor, name, null), RReliableTopicRx.class);
    }

    @Override
    public RReliableTopicRx getReliableTopic(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonReliableTopic(codec, this.commandExecutor, name, null), RReliableTopicRx.class);
    }

    @Override
    public RPatternTopicRx getPatternTopic(String pattern) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(this.commandExecutor, pattern), RPatternTopicRx.class);
    }

    @Override
    public RPatternTopicRx getPatternTopic(String pattern, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(codec, this.commandExecutor, pattern), RPatternTopicRx.class);
    }

    @Override
    public <V> RQueueRx<V> getQueue(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonQueue(this.commandExecutor, name, null), new RedissonListRx(new RedissonList(this.commandExecutor, name, null)), RQueueRx.class);
    }

    @Override
    public <V> RQueueRx<V> getQueue(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonQueue(codec, this.commandExecutor, name, null), new RedissonListRx(new RedissonList(codec, this.commandExecutor, name, null)), RQueueRx.class);
    }

    @Override
    public <V> RRingBufferRx<V> getRingBuffer(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRingBuffer(this.commandExecutor, name, null), RRingBufferRx.class);
    }

    @Override
    public <V> RRingBufferRx<V> getRingBuffer(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRingBuffer(codec, this.commandExecutor, name, null), RRingBufferRx.class);
    }

    @Override
    public <V> RBlockingQueueRx<V> getBlockingQueue(String name) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueRx(queue), RBlockingQueueRx.class);
    }

    @Override
    public <V> RBlockingQueueRx<V> getBlockingQueue(String name, Codec codec) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueRx(queue), RBlockingQueueRx.class);
    }

    @Override
    public <V> RDequeRx<V> getDeque(String name) {
        RedissonDeque queue = new RedissonDeque(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonListRx(queue), RDequeRx.class);
    }

    @Override
    public <V> RDequeRx<V> getDeque(String name, Codec codec) {
        RedissonDeque queue = new RedissonDeque(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonListRx(queue), RDequeRx.class);
    }

    @Override
    public <V, L> RTimeSeriesRx<V, L> getTimeSeries(String name) {
        RedissonTimeSeries timeSeries = new RedissonTimeSeries(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, timeSeries, new RedissonTimeSeriesRx(timeSeries, this), RTimeSeriesRx.class);
    }

    @Override
    public <V, L> RTimeSeriesRx<V, L> getTimeSeries(String name, Codec codec) {
        RedissonTimeSeries timeSeries = new RedissonTimeSeries(codec, this.evictionScheduler, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, timeSeries, new RedissonTimeSeriesRx(timeSeries, this), RTimeSeriesRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name) {
        RedissonSetCache set = new RedissonSetCache(this.evictionScheduler, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheRx(set, this), RSetCacheRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name, Codec codec) {
        RedissonSetCache set = new RedissonSetCache(codec, this.evictionScheduler, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheRx(set, this), RSetCacheRx.class);
    }

    @Override
    public RAtomicLongRx getAtomicLong(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicLong(this.commandExecutor, name), RAtomicLongRx.class);
    }

    @Override
    public RAtomicDoubleRx getAtomicDouble(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicDouble(this.commandExecutor, name), RAtomicDoubleRx.class);
    }

    @Override
    public RRemoteService getRemoteService() {
        return this.getRemoteService("redisson_rs", this.connectionManager.getServiceManager().getCfg().getCodec());
    }

    @Override
    public RRemoteService getRemoteService(String name) {
        return this.getRemoteService(name, this.connectionManager.getServiceManager().getCfg().getCodec());
    }

    @Override
    public RRemoteService getRemoteService(Codec codec) {
        return this.getRemoteService("redisson_rs", codec);
    }

    @Override
    public RRemoteService getRemoteService(String name, Codec codec) {
        String executorId = this.connectionManager.getServiceManager().getId();
        if (codec != this.connectionManager.getServiceManager().getCfg().getCodec()) {
            executorId = executorId + ":" + name;
        }
        return new RedissonRemoteService(codec, name, this.commandExecutor, executorId, this.responses);
    }

    @Override
    public RBitSetRx getBitSet(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBitSet(this.commandExecutor, name), RBitSetRx.class);
    }

    @Override
    public RFunctionRx getFunction() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFuction(this.commandExecutor), RFunctionRx.class);
    }

    @Override
    public RFunctionRx getFunction(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFuction(this.commandExecutor, codec), RFunctionRx.class);
    }

    @Override
    public RScriptRx getScript() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor), RScriptRx.class);
    }

    @Override
    public RScriptRx getScript(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor, codec), RScriptRx.class);
    }

    @Override
    public RBatchRx createBatch() {
        return this.createBatch(BatchOptions.defaults());
    }

    @Override
    public RBatchRx createBatch(BatchOptions options) {
        return new RedissonBatchRx(this.evictionScheduler, this.connectionManager, this.commandExecutor, options);
    }

    @Override
    public RKeysRx getKeys() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonKeys(this.commandExecutor), new RedissonKeysRx(this.commandExecutor), RKeysRx.class);
    }

    @Override
    public Config getConfig() {
        return this.connectionManager.getServiceManager().getCfg();
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager, this.connectionManager.getServiceManager(), this.commandExecutor);
    }

    @Override
    public NodesGroup<ClusterNode> getClusterNodesGroup() {
        if (!this.connectionManager.isClusterMode()) {
            throw new IllegalStateException("Redisson not in cluster mode!");
        }
        return new RedisNodes<ClusterNode>(this.connectionManager, this.connectionManager.getServiceManager(), this.commandExecutor);
    }

    @Override
    public void shutdown() {
        this.writeBehindService.stop();
        this.connectionManager.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.connectionManager.getServiceManager().isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.connectionManager.getServiceManager().isShuttingDown();
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(codec, this.evictionScheduler, this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx<K, V>(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx<K, V>(map, this.commandExecutor), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(codec, this.commandExecutor, name, null, options, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this.commandExecutor), RMapRx.class);
    }

    @Override
    public <K, V> RLocalCachedMapRx<K, V> getLocalCachedMap(String name, LocalCachedMapOptions<K, V> options) {
        RedissonLocalCachedMap<K, V> map = new RedissonLocalCachedMap<K, V>(this.commandExecutor, name, options, this.evictionScheduler, null, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this.commandExecutor), RLocalCachedMapRx.class);
    }

    @Override
    public <K, V> RLocalCachedMapRx<K, V> getLocalCachedMap(String name, Codec codec, LocalCachedMapOptions<K, V> options) {
        RedissonLocalCachedMap<K, V> map = new RedissonLocalCachedMap<K, V>(codec, this.commandExecutor, name, options, this.evictionScheduler, null, this.writeBehindService);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this.commandExecutor), RLocalCachedMapRx.class);
    }

    @Override
    public RTransactionRx createTransaction(TransactionOptions options) {
        return new RedissonTransactionRx(this.commandExecutor, options);
    }

    @Override
    public <V> RBlockingDequeRx<V> getBlockingDeque(String name) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeRx(deque), RBlockingDequeRx.class);
    }

    @Override
    public <V> RBlockingDequeRx<V> getBlockingDeque(String name, Codec codec) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeRx(deque), RBlockingDequeRx.class);
    }

    @Override
    public <V> RTransferQueueRx<V> getTransferQueue(String name) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        RedissonTransferQueue queue = new RedissonTransferQueue(this.commandExecutor, name, service);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonTransferQueueRx(queue), RTransferQueueRx.class);
    }

    @Override
    public <V> RTransferQueueRx<V> getTransferQueue(String name, Codec codec) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        RedissonTransferQueue queue = new RedissonTransferQueue(codec, this.commandExecutor, name, service);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonTransferQueueRx(queue), RTransferQueueRx.class);
    }

    @Override
    public String getId() {
        return this.commandExecutor.getServiceManager().getId();
    }
}

