/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemoteExecutorService;
import org.redisson.executor.RemotePromise;
import org.redisson.executor.params.TaskParameters;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.remote.BaseRemoteService;
import org.redisson.remote.RemoteServiceCancelRequest;
import org.redisson.remote.RemoteServiceCancelResponse;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.ResponseEntry;

public class TasksService
extends BaseRemoteService {
    protected String terminationTopicName;
    protected String tasksCounterName;
    protected String statusName;
    protected String tasksName;
    protected String schedulerQueueName;
    protected String schedulerChannelName;
    protected String tasksRetryIntervalName;
    protected String tasksExpirationTimeName;
    protected long tasksRetryInterval;

    public TasksService(Codec codec, String name, CommandAsyncExecutor commandExecutor, String executorId, ConcurrentMap<String, ResponseEntry> responses) {
        super(codec, name, commandExecutor, executorId, responses);
    }

    public void setTasksExpirationTimeName(String tasksExpirationTimeName) {
        this.tasksExpirationTimeName = tasksExpirationTimeName;
    }

    public void setTasksRetryIntervalName(String tasksRetryIntervalName) {
        this.tasksRetryIntervalName = tasksRetryIntervalName;
    }

    public void setTasksRetryInterval(long tasksRetryInterval) {
        this.tasksRetryInterval = tasksRetryInterval;
    }

    public void setTerminationTopicName(String terminationTopicName) {
        this.terminationTopicName = terminationTopicName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    public void setTasksName(String tasksName) {
        this.tasksName = tasksName;
    }

    public void setSchedulerChannelName(String schedulerChannelName) {
        this.schedulerChannelName = schedulerChannelName;
    }

    public void setSchedulerQueueName(String scheduledQueueName) {
        this.schedulerQueueName = scheduledQueueName;
    }

    @Override
    protected final CompletableFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request, RemotePromise<Object> result) {
        CompletableFuture<Boolean> future = this.addAsync(requestQueueName, request);
        result.setAddFuture(future);
        return future.thenApply(res -> {
            if (!res.booleanValue()) {
                throw new IllegalStateException("Task hasn't been added. Check if executorService exists and task id is unique");
            }
            return true;
        });
    }

    protected CommandAsyncExecutor getAddCommandExecutor() {
        return this.commandExecutor;
    }

    protected CompletableFuture<Boolean> addAsync(String requestQueueName, RemoteServiceRequest request) {
        TaskParameters params = (TaskParameters)request.getArgs()[0];
        long retryStartTime = 0L;
        if (this.tasksRetryInterval > 0L) {
            retryStartTime = System.currentTimeMillis() + this.tasksRetryInterval;
        }
        long expireTime = 0L;
        if (params.getTtl() > 0L) {
            expireTime = System.currentTimeMillis() + params.getTtl();
        }
        RFuture f = this.getAddCommandExecutor().evalWriteNoRetryAsync(this.name, StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then redis.call('hset', KEYS[5], ARGV[2], ARGV[3]);redis.call('rpush', KEYS[6], ARGV[2]); redis.call('incr', KEYS[1]);if tonumber(ARGV[5]) > 0 then redis.call('zadd', KEYS[8], ARGV[5], ARGV[2]);end; if tonumber(ARGV[1]) > 0 then redis.call('set', KEYS[7], ARGV[4]);redis.call('zadd', KEYS[3], ARGV[1], 'ff:' .. ARGV[2]);local v = redis.call('zrange', KEYS[3], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[4], ARGV[1]); end; end;return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksName, requestQueueName, this.tasksRetryIntervalName, this.tasksExpirationTimeName), retryStartTime, request.getId(), this.encode(request), this.tasksRetryInterval, expireTime);
        return f.toCompletableFuture();
    }

    @Override
    protected CompletableFuture<Boolean> removeAsync(String requestQueueName, String taskId) {
        RFuture f = this.commandExecutor.evalWriteNoRetryAsync(this.name, LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[3]) == 0 then return nil;end;redis.call('zrem', KEYS[2], 'ff:' .. ARGV[1]); redis.call('zrem', KEYS[8], ARGV[1]); local task = redis.call('hget', KEYS[6], ARGV[1]); redis.call('hdel', KEYS[6], ARGV[1]); local removed = redis.call('lrem', KEYS[1], 1, ARGV[1]); if task ~= false and removed > 0 then if redis.call('decr', KEYS[3]) == 0 then redis.call('del', KEYS[3]);if redis.call('get', KEYS[4]) == ARGV[2] then redis.call('del', KEYS[7]);redis.call('set', KEYS[4], ARGV[3]);redis.call('publish', KEYS[5], ARGV[3]);end;end;return 1;end;if task == false then return nil; end;return 0;", Arrays.asList(requestQueueName, this.schedulerQueueName, this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName, this.tasksRetryIntervalName, this.tasksExpirationTimeName), taskId, 1, 2);
        return f.toCompletableFuture();
    }

    @Override
    protected String generateRequestId(Object[] args) {
        TaskParameters params = (TaskParameters)args[0];
        return params.getRequestId();
    }

    public RFuture<Boolean> cancelExecutionAsync(String requestId) {
        String requestQueueName = this.getRequestQueueName(RemoteExecutorService.class);
        CompletableFuture<Boolean> removeFuture = this.removeAsync(requestQueueName, requestId);
        CompletionStage f = removeFuture.thenCompose(res -> {
            if (res == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (res.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            RMap<String, RemoteServiceCancelRequest> canceledRequests = this.getMap(this.cancelRequestMapName);
            canceledRequests.putAsync(requestId, new RemoteServiceCancelRequest(true, true));
            canceledRequests.expireAsync(60L, TimeUnit.SECONDS);
            CompletableFuture<RemoteServiceCancelResponse> response = this.scheduleCancelResponseCheck(this.cancelResponseMapName, requestId);
            return response.thenApply(r -> {
                if (r == null) {
                    return false;
                }
                return r.isCanceled();
            });
        });
        removeFuture.thenAccept(arg_0 -> this.lambda$cancelExecutionAsync$4((CompletableFuture)f, arg_0));
        return new CompletableFutureWrapper<Boolean>((CompletableFuture<Boolean>)f);
    }

    private CompletableFuture<RemoteServiceCancelResponse> scheduleCancelResponseCheck(String mapName, String requestId) {
        CompletableFuture<RemoteServiceCancelResponse> cancelResponse = new CompletableFuture<RemoteServiceCancelResponse>();
        this.commandExecutor.getServiceManager().newTimeout(timeout -> {
            if (cancelResponse.isDone()) {
                return;
            }
            RMap canceledResponses = this.getMap(mapName);
            RFuture removeFuture = canceledResponses.removeAsync(requestId);
            CompletableFuture<RemoteServiceCancelResponse> future = removeFuture.thenCompose(response -> {
                if (response == null) {
                    RFuture<Boolean> f = this.hasTaskAsync(requestId);
                    return f.thenCompose(r -> {
                        if (r.booleanValue()) {
                            return this.scheduleCancelResponseCheck(mapName, requestId);
                        }
                        RemoteServiceCancelResponse resp = new RemoteServiceCancelResponse(requestId, false);
                        return CompletableFuture.completedFuture(resp);
                    });
                }
                return CompletableFuture.completedFuture(response);
            }).whenComplete((r, ex) -> {
                if (ex != null) {
                    this.scheduleCancelResponseCheck(mapName, requestId);
                }
            }).toCompletableFuture();
            this.commandExecutor.transfer(future, cancelResponse);
        }, 3000L, TimeUnit.MILLISECONDS);
        return cancelResponse;
    }

    public RFuture<Boolean> hasTaskAsync(String taskId) {
        return this.commandExecutor.writeAsync(this.tasksName, (Codec)LongCodec.INSTANCE, RedisCommands.HEXISTS, this.tasksName, taskId);
    }

    private /* synthetic */ void lambda$cancelExecutionAsync$4(CompletableFuture f, Boolean r) {
        this.commandExecutor.getServiceManager().newTimeout(timeout -> f.complete(false), 60L, TimeUnit.SECONDS);
    }
}

