/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.redisson.ScanResult;
import org.redisson.client.RedisClient;

public abstract class BaseIterator<V, E>
implements Iterator<V> {
    private Iterator<E> lastIter;
    protected long nextIterPos;
    protected RedisClient client;
    private boolean finished;
    private boolean currentElementRemoved;
    protected E value;

    @Override
    public boolean hasNext() {
        if (this.lastIter == null || !this.lastIter.hasNext()) {
            if (this.finished) {
                this.currentElementRemoved = false;
                this.client = null;
                this.nextIterPos = 0L;
                if (!this.tryAgain()) {
                    return false;
                }
                this.finished = false;
            }
            do {
                ScanResult<E> res = this.iterator(this.client, this.nextIterPos);
                this.client = res.getRedisClient();
                this.lastIter = res.getValues().iterator();
                this.nextIterPos = res.getPos();
                if (res.getPos() != 0L) continue;
                this.finished = true;
                if (!res.getValues().isEmpty()) continue;
                this.currentElementRemoved = false;
                this.client = null;
                this.nextIterPos = 0L;
                if (this.tryAgain()) continue;
                return false;
            } while (!this.lastIter.hasNext());
        }
        return this.lastIter.hasNext();
    }

    protected boolean tryAgain() {
        return false;
    }

    protected abstract ScanResult<E> iterator(RedisClient var1, long var2);

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element");
        }
        this.value = this.lastIter.next();
        this.currentElementRemoved = false;
        return this.getValue(this.value);
    }

    protected abstract V getValue(E var1);

    @Override
    public void remove() {
        if (this.currentElementRemoved) {
            throw new IllegalStateException("Element been already deleted");
        }
        if (this.lastIter == null || this.value == null) {
            throw new IllegalStateException();
        }
        this.lastIter.remove();
        this.remove(this.value);
        this.currentElementRemoved = true;
    }

    protected abstract void remove(E var1);
}

