/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;

public class LRUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final AtomicLong index = new AtomicLong();
    private final List<OrderedSet<CachedValue<K, V>>> queues = new ArrayList<OrderedSet<CachedValue<K, V>>>();

    public LRUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 2; ++i) {
            this.queues.add(new OrderedSet());
        }
    }

    @Override
    protected void onValueCreate(CachedValue<K, V> value) {
        OrderedSet<CachedValue<K, CachedValue<K, V>>> queue = this.getQueue(value);
        queue.add(value);
    }

    private OrderedSet<CachedValue<K, V>> getQueue(CachedValue<K, V> value) {
        return this.queues.get(Math.abs(value.hashCode() % this.queues.size()));
    }

    @Override
    protected void onValueRemove(CachedValue<K, V> value) {
        OrderedSet<CachedValue<K, CachedValue<K, V>>> queue = this.getQueue(value);
        queue.remove(value);
    }

    @Override
    protected void onValueRead(CachedValue<K, V> value) {
        OrderedSet<CachedValue<K, CachedValue<K, V>>> queue = this.getQueue(value);
        if (queue.remove(value)) {
            queue.add(value);
        }
    }

    @Override
    protected void onMapFull() {
        int queueIndex;
        OrderedSet<CachedValue<K, V>> queue;
        CachedValue<K, V> removedValue;
        int startIndex = -1;
        do {
            if ((queueIndex = (int)Math.abs(this.index.incrementAndGet() % (long)this.queues.size())) == startIndex) {
                return;
            }
            if (startIndex != -1) continue;
            startIndex = queueIndex;
        } while ((removedValue = (queue = this.queues.get(queueIndex)).removeFirst()) == null);
        this.map.remove(removedValue.getKey(), removedValue);
    }

    @Override
    public void clear() {
        for (OrderedSet<CachedValue<K, V>> collection : this.queues) {
            collection.clear();
        }
        super.clear();
    }

    static class OrderedSet<V> {
        final Queue<V> queue = new ConcurrentLinkedQueue<V>();
        final Set<V> set = Collections.newSetFromMap(new ConcurrentHashMap());

        OrderedSet() {
        }

        void add(V element) {
            if (this.set.add(element)) {
                this.queue.add(element);
            }
        }

        boolean remove(V element) {
            if (this.set.remove(element)) {
                this.queue.remove(element);
                return true;
            }
            return false;
        }

        V removeFirst() {
            V v;
            while ((v = this.queue.poll()) != null) {
                if (!this.set.remove(v)) continue;
                return v;
            }
            return v;
        }

        void clear() {
            this.set.clear();
            this.queue.clear();
        }
    }
}

