/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

public enum ObjectEncoding {
    RAW("raw"),
    INT("int"),
    EMBSTR("embstr"),
    LINKEDLIST("linkedlist"),
    ZIPLIST("ziplist"),
    LISTPACK("listpack"),
    QUICKLIST("quicklist"),
    HASHTABLE("hashtable"),
    INTSET("intset"),
    ZIPMAP("zipmap"),
    SKIPLIST("skiplist"),
    STREAM("stream"),
    NULL("nonexistence"),
    UNKNOWN("unknown");

    private final String type;

    private ObjectEncoding(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static ObjectEncoding valueOfEncoding(Object object) {
        if (object == null) {
            return NULL;
        }
        String value = (String)object;
        for (ObjectEncoding encoding : ObjectEncoding.values()) {
            if (!value.equals(encoding.getType())) continue;
            return encoding;
        }
        return UNKNOWN;
    }
}

