/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.CompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileAnnotationSheet
extends AbstractFileCompareSheet {
    static final int ANNOTATION_COL_WIDTH = 80;

    public FileAnnotationSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 80);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return fileA.arraysEquivalent(fileA.getAnnotations(), fileB.getAnnotations());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        return CompareHelper.annotationsToString(spdxFile.getAnnotations());
    }
}

