/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;

public class ExtractedLicensingInfoContext {
    private Exception error = null;
    private ExtractedLicenseInfo license = null;
    private String licenseLink;

    public ExtractedLicensingInfoContext(InvalidSPDXAnalysisException e) {
        this.error = e;
    }

    public ExtractedLicensingInfoContext(ExtractedLicenseInfo spdxNonStandardLicense, Map<String, String> spdxIdToUrl) {
        this.license = spdxNonStandardLicense;
        if (this.license != null) {
            this.licenseLink = spdxIdToUrl.get(this.license.getLicenseId());
        }
    }

    public String licenseId() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getLicenseId();
        }
        return null;
    }

    public String extractedText() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getExtractedText();
        }
        return null;
    }

    public String comment() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getComment();
        }
        return null;
    }

    public String licenseName() {
        if (this.license == null && this.error != null) {
            return "Error getting non-standard license: " + this.error.getMessage();
        }
        if (this.license != null) {
            return this.license.getName();
        }
        return null;
    }

    public List<String> crossReferenceUrls() {
        ArrayList retval = Lists.newArrayList();
        if (this.license != null) {
            String[] crossRefUrls = this.license.getSeeAlso();
            if (crossRefUrls != null) {
                for (int i = 0; i < crossRefUrls.length; ++i) {
                    retval.add(crossRefUrls[i]);
                }
            }
        } else if (this.error != null) {
            retval.add("Error getting extracted licensing info: " + this.error);
        }
        return retval;
    }

    public String getLicenseLink() {
        return this.licenseLink;
    }

    public void setLicenseLink(String licenseLink) {
        this.licenseLink = licenseLink;
    }
}

