/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.observation.autoconfigure;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.tracing.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.observation.TracingAwareLoggingObservationHandler;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.ai.vectorstore.observation.VectorStoreQueryResponseObservationHandler;
import org.springframework.ai.vectorstore.observation.autoconfigure.VectorStoreObservationProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(afterName={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@ConditionalOnClass(value={VectorStore.class})
@EnableConfigurationProperties(value={VectorStoreObservationProperties.class})
public class VectorStoreObservationAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(VectorStoreObservationAutoConfiguration.class);

    private static void logQueryResponseContentWarning() {
        logger.warn("You have enabled logging out of the query response content with the risk of exposing sensitive or private information. Please, be careful!");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.tracing.Tracer"})
    static class TracerNotPresentObservationConfiguration {
        TracerNotPresentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.vectorstore.observations", name={"log-query-response"}, havingValue="true")
        VectorStoreQueryResponseObservationHandler vectorStoreQueryResponseObservationHandler() {
            VectorStoreObservationAutoConfiguration.logQueryResponseContentWarning();
            return new VectorStoreQueryResponseObservationHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    @ConditionalOnBean(value={Tracer.class})
    static class TracerPresentObservationConfiguration {
        TracerPresentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={VectorStoreQueryResponseObservationHandler.class}, name={"vectorStoreQueryResponseObservationHandler"})
        @ConditionalOnProperty(prefix="spring.ai.vectorstore.observations", name={"log-query-response"}, havingValue="true")
        TracingAwareLoggingObservationHandler<VectorStoreObservationContext> vectorStoreQueryResponseObservationHandler(Tracer tracer) {
            VectorStoreObservationAutoConfiguration.logQueryResponseContentWarning();
            return new TracingAwareLoggingObservationHandler((ObservationHandler)new VectorStoreQueryResponseObservationHandler(), tracer);
        }
    }
}

