/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.DefaultChatClientBuilder;
import org.springframework.ai.chat.client.ResponseEntity;
import org.springframework.ai.chat.client.advisor.DefaultAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationDocumentation;
import org.springframework.ai.chat.client.observation.DefaultChatClientObservationConvention;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.ai.converter.StructuredOutputConverter;
import org.springframework.ai.model.Media;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.ToolCallbacks;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class DefaultChatClient
implements ChatClient {
    private static final ChatClientObservationConvention DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION = new DefaultChatClientObservationConvention();
    private final DefaultChatClientRequestSpec defaultChatClientRequest;

    public DefaultChatClient(DefaultChatClientRequestSpec defaultChatClientRequest) {
        Assert.notNull((Object)defaultChatClientRequest, (String)"defaultChatClientRequest cannot be null");
        this.defaultChatClientRequest = defaultChatClientRequest;
    }

    private static AdvisedRequest toAdvisedRequest(DefaultChatClientRequestSpec inputRequest, @Nullable String formatParam) {
        Message lastMessage;
        Assert.notNull((Object)inputRequest, (String)"inputRequest cannot be null");
        ConcurrentHashMap<String, Object> advisorContext = new ConcurrentHashMap<String, Object>(inputRequest.getAdvisorParams());
        if (StringUtils.hasText((String)formatParam)) {
            advisorContext.put("formatParam", formatParam);
        }
        String userText = inputRequest.userText;
        List<Media> media = inputRequest.media;
        List<Message> messages = inputRequest.messages;
        if (!StringUtils.hasText((String)userText) && !CollectionUtils.isEmpty(messages) && (lastMessage = messages.get(messages.size() - 1)).getMessageType() == MessageType.USER) {
            List<Media> messageMedia;
            UserMessage userMessage = (UserMessage)lastMessage;
            if (StringUtils.hasText((String)userMessage.getText())) {
                userText = lastMessage.getText();
            }
            if (!CollectionUtils.isEmpty(messageMedia = userMessage.getMedia())) {
                media.addAll(messageMedia);
            }
            messages = messages.subList(0, messages.size() - 1);
        }
        return new AdvisedRequest(inputRequest.chatModel, userText, inputRequest.systemText, inputRequest.chatOptions, media, inputRequest.functionNames, inputRequest.functionCallbacks, messages, inputRequest.userParams, inputRequest.systemParams, inputRequest.advisors, inputRequest.advisorParams, advisorContext, inputRequest.toolContext);
    }

    public static DefaultChatClientRequestSpec toDefaultChatClientRequestSpec(AdvisedRequest advisedRequest, ObservationRegistry observationRegistry, ChatClientObservationConvention customObservationConvention) {
        return new DefaultChatClientRequestSpec(advisedRequest.chatModel(), advisedRequest.userText(), advisedRequest.userParams(), advisedRequest.systemText(), advisedRequest.systemParams(), advisedRequest.functionCallbacks(), advisedRequest.messages(), advisedRequest.functionNames(), advisedRequest.media(), advisedRequest.chatOptions(), advisedRequest.advisors(), advisedRequest.advisorParams(), observationRegistry, customObservationConvention, advisedRequest.toolContext());
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt() {
        return new DefaultChatClientRequestSpec(this.defaultChatClientRequest);
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt(String content) {
        Assert.hasText((String)content, (String)"content cannot be null or empty");
        return this.prompt(new Prompt(content));
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt(Prompt prompt) {
        Assert.notNull((Object)prompt, (String)"prompt cannot be null");
        DefaultChatClientRequestSpec spec = new DefaultChatClientRequestSpec(this.defaultChatClientRequest);
        if (prompt.getOptions() != null) {
            spec.options(prompt.getOptions());
        }
        if (prompt.getInstructions() != null) {
            spec.messages((List<Message>)prompt.getInstructions());
        }
        return spec;
    }

    @Override
    public ChatClient.Builder mutate() {
        return this.defaultChatClientRequest.mutate();
    }

    public static class DefaultChatClientRequestSpec
    implements ChatClient.ChatClientRequestSpec {
        private final ObservationRegistry observationRegistry;
        private final ChatClientObservationConvention customObservationConvention;
        private final ChatModel chatModel;
        private final List<Media> media = new ArrayList<Media>();
        private final List<String> functionNames = new ArrayList<String>();
        private final List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
        private final List<Message> messages = new ArrayList<Message>();
        private final Map<String, Object> userParams = new HashMap<String, Object>();
        private final Map<String, Object> systemParams = new HashMap<String, Object>();
        private final List<Advisor> advisors = new ArrayList<Advisor>();
        private final Map<String, Object> advisorParams = new HashMap<String, Object>();
        private final DefaultAroundAdvisorChain.Builder aroundAdvisorChainBuilder;
        private final Map<String, Object> toolContext = new HashMap<String, Object>();
        @Nullable
        private String userText;
        @Nullable
        private String systemText;
        @Nullable
        private ChatOptions chatOptions;

        DefaultChatClientRequestSpec(DefaultChatClientRequestSpec ccr) {
            this(ccr.chatModel, ccr.userText, ccr.userParams, ccr.systemText, ccr.systemParams, ccr.functionCallbacks, ccr.messages, ccr.functionNames, ccr.media, ccr.chatOptions, ccr.advisors, ccr.advisorParams, ccr.observationRegistry, ccr.customObservationConvention, ccr.toolContext);
        }

        public DefaultChatClientRequestSpec(final ChatModel chatModel, @Nullable String userText, Map<String, Object> userParams, @Nullable String systemText, Map<String, Object> systemParams, List<FunctionCallback> functionCallbacks, List<Message> messages, List<String> functionNames, List<Media> media, @Nullable ChatOptions chatOptions, List<Advisor> advisors, Map<String, Object> advisorParams, ObservationRegistry observationRegistry, @Nullable ChatClientObservationConvention customObservationConvention, Map<String, Object> toolContext) {
            Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
            Assert.notNull(userParams, (String)"userParams cannot be null");
            Assert.notNull(systemParams, (String)"systemParams cannot be null");
            Assert.notNull(functionCallbacks, (String)"functionCallbacks cannot be null");
            Assert.notNull(messages, (String)"messages cannot be null");
            Assert.notNull(functionNames, (String)"functionNames cannot be null");
            Assert.notNull(media, (String)"media cannot be null");
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.notNull(advisorParams, (String)"advisorParams cannot be null");
            Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
            Assert.notNull(toolContext, (String)"toolContext cannot be null");
            this.chatModel = chatModel;
            this.chatOptions = chatOptions != null ? chatOptions.copy() : (chatModel.getDefaultOptions() != null ? chatModel.getDefaultOptions().copy() : null);
            this.userText = userText;
            this.userParams.putAll(userParams);
            this.systemText = systemText;
            this.systemParams.putAll(systemParams);
            this.functionNames.addAll(functionNames);
            this.functionCallbacks.addAll(functionCallbacks);
            this.messages.addAll(messages);
            this.media.addAll(media);
            this.advisors.addAll(advisors);
            this.advisorParams.putAll(advisorParams);
            this.observationRegistry = observationRegistry;
            this.customObservationConvention = customObservationConvention != null ? customObservationConvention : DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION;
            this.toolContext.putAll(toolContext);
            this.advisors.add(new CallAroundAdvisor(){

                @Override
                public String getName() {
                    return CallAroundAdvisor.class.getSimpleName();
                }

                public int getOrder() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
                    return new AdvisedResponse(chatModel.call(advisedRequest.toPrompt()), Collections.unmodifiableMap(advisedRequest.adviseContext()));
                }
            });
            this.advisors.add(new StreamAroundAdvisor(){

                @Override
                public String getName() {
                    return StreamAroundAdvisor.class.getSimpleName();
                }

                public int getOrder() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
                    return chatModel.stream(advisedRequest.toPrompt()).map(chatResponse -> new AdvisedResponse((ChatResponse)chatResponse, Collections.unmodifiableMap(advisedRequest.adviseContext()))).publishOn(Schedulers.boundedElastic());
                }
            });
            this.aroundAdvisorChainBuilder = DefaultAroundAdvisorChain.builder(observationRegistry).pushAll(this.advisors);
        }

        private ObservationRegistry getObservationRegistry() {
            return this.observationRegistry;
        }

        private ChatClientObservationConvention getCustomObservationConvention() {
            return this.customObservationConvention;
        }

        @Nullable
        public String getUserText() {
            return this.userText;
        }

        public Map<String, Object> getUserParams() {
            return this.userParams;
        }

        @Nullable
        public String getSystemText() {
            return this.systemText;
        }

        public Map<String, Object> getSystemParams() {
            return this.systemParams;
        }

        @Nullable
        public ChatOptions getChatOptions() {
            return this.chatOptions;
        }

        public List<Advisor> getAdvisors() {
            return this.advisors;
        }

        public Map<String, Object> getAdvisorParams() {
            return this.advisorParams;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public List<Media> getMedia() {
            return this.media;
        }

        public List<String> getFunctionNames() {
            return this.functionNames;
        }

        public List<FunctionCallback> getFunctionCallbacks() {
            return this.functionCallbacks;
        }

        public Map<String, Object> getToolContext() {
            return this.toolContext;
        }

        @Override
        public ChatClient.Builder mutate() {
            DefaultChatClientBuilder builder = (DefaultChatClientBuilder)ChatClient.builder(this.chatModel, this.observationRegistry, this.customObservationConvention).defaultFunctions(StringUtils.toStringArray(this.functionNames));
            if (StringUtils.hasText((String)this.userText)) {
                builder.defaultUser(u -> u.text(this.userText).params(this.userParams).media(this.media.toArray(new Media[0])));
            }
            if (StringUtils.hasText((String)this.systemText)) {
                builder.defaultSystem(s -> s.text(this.systemText).params(this.systemParams));
            }
            if (this.chatOptions != null) {
                builder.defaultOptions(this.chatOptions);
            }
            builder.addMessages(this.messages);
            builder.addToolCallbacks(this.functionCallbacks);
            builder.addToolContext(this.toolContext);
            return builder;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(Consumer<ChatClient.AdvisorSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultAdvisorSpec advisorSpec = new DefaultAdvisorSpec();
            consumer.accept(advisorSpec);
            this.advisorParams.putAll(advisorSpec.getParams());
            this.advisors.addAll(advisorSpec.getAdvisors());
            this.aroundAdvisorChainBuilder.pushAll(advisorSpec.getAdvisors());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(Advisor ... advisors) {
            Assert.notNull((Object)advisors, (String)"advisors cannot be null");
            Assert.noNullElements((Object[])advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(Arrays.asList(advisors));
            this.aroundAdvisorChainBuilder.pushAll(Arrays.asList(advisors));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(List<Advisor> advisors) {
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(advisors);
            this.aroundAdvisorChainBuilder.pushAll(advisors);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec messages(Message ... messages) {
            Assert.notNull((Object)messages, (String)"messages cannot be null");
            Assert.noNullElements((Object[])messages, (String)"messages cannot contain null elements");
            this.messages.addAll(List.of(messages));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec messages(List<Message> messages) {
            Assert.notNull(messages, (String)"messages cannot be null");
            Assert.noNullElements(messages, (String)"messages cannot contain null elements");
            this.messages.addAll(messages);
            return this;
        }

        @Override
        public <T extends ChatOptions> ChatClient.ChatClientRequestSpec options(T options) {
            Assert.notNull(options, (String)"options cannot be null");
            this.chatOptions = options;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec tools(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            Assert.noNullElements((Object[])toolNames, (String)"toolNames cannot contain null elements");
            this.functionNames.addAll(List.of(toolNames));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec tools(FunctionCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements((Object[])toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.functionCallbacks.addAll(List.of(toolCallbacks));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec tools(List<ToolCallback> toolCallbacks) {
            Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.functionCallbacks.addAll(toolCallbacks);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec tools(Object ... toolObjects) {
            Assert.notNull((Object)toolObjects, (String)"toolObjects cannot be null");
            Assert.noNullElements((Object[])toolObjects, (String)"toolObjects cannot contain null elements");
            this.functionCallbacks.addAll(Arrays.asList(ToolCallbacks.from(toolObjects)));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec tools(ToolCallbackProvider ... toolCallbackProviders) {
            Assert.notNull((Object)toolCallbackProviders, (String)"toolCallbackProviders cannot be null");
            Assert.noNullElements((Object[])toolCallbackProviders, (String)"toolCallbackProviders cannot contain null elements");
            for (ToolCallbackProvider toolCallbackProvider : toolCallbackProviders) {
                this.functionCallbacks.addAll(List.of(toolCallbackProvider.getToolCallbacks()));
            }
            return this;
        }

        @Override
        @Deprecated
        public ChatClient.ChatClientRequestSpec functions(String ... functionBeanNames) {
            return this.tools(functionBeanNames);
        }

        @Override
        @Deprecated
        public ChatClient.ChatClientRequestSpec functions(FunctionCallback ... functionCallbacks) {
            Assert.notNull((Object)functionCallbacks, (String)"functionCallbacks cannot be null");
            Assert.noNullElements((Object[])functionCallbacks, (String)"functionCallbacks cannot contain null elements");
            this.functionCallbacks.addAll(Arrays.asList(functionCallbacks));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolContext(Map<String, Object> toolContext) {
            Assert.notNull(toolContext, (String)"toolContext cannot be null");
            Assert.noNullElements(toolContext.keySet(), (String)"toolContext keys cannot contain null elements");
            Assert.noNullElements(toolContext.values(), (String)"toolContext values cannot contain null elements");
            this.toolContext.putAll(toolContext);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.systemText = text;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.systemText = text.getContentAsString(charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            return this.system(text, Charset.defaultCharset());
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Consumer<ChatClient.PromptSystemSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultPromptSystemSpec systemSpec = new DefaultPromptSystemSpec();
            consumer.accept(systemSpec);
            this.systemText = StringUtils.hasText((String)systemSpec.text()) ? systemSpec.text() : this.systemText;
            this.systemParams.putAll(systemSpec.params());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.userText = text;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.userText = text.getContentAsString(charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            return this.user(text, Charset.defaultCharset());
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Consumer<ChatClient.PromptUserSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultPromptUserSpec us = new DefaultPromptUserSpec();
            consumer.accept(us);
            this.userText = StringUtils.hasText((String)us.text()) ? us.text() : this.userText;
            this.userParams.putAll(us.params());
            this.media.addAll(us.media());
            return this;
        }

        @Override
        public ChatClient.CallResponseSpec call() {
            return new DefaultCallResponseSpec(this);
        }

        @Override
        public ChatClient.StreamResponseSpec stream() {
            return new DefaultStreamResponseSpec(this);
        }
    }

    public static class DefaultStreamPromptResponseSpec
    implements ChatClient.StreamPromptResponseSpec {
        private final Prompt prompt;
        private final StreamingChatModel chatModel;

        public DefaultStreamPromptResponseSpec(StreamingChatModel streamingChatModel, Prompt prompt) {
            Assert.notNull((Object)streamingChatModel, (String)"streamingChatModel cannot be null");
            Assert.notNull((Object)prompt, (String)"prompt cannot be null");
            this.chatModel = streamingChatModel;
            this.prompt = prompt;
        }

        @Override
        public Flux<ChatResponse> chatResponse() {
            return this.doGetFluxChatResponse(this.prompt);
        }

        private Flux<ChatResponse> doGetFluxChatResponse(Prompt prompt) {
            return this.chatModel.stream(prompt);
        }

        @Override
        public Flux<String> content() {
            return this.doGetFluxChatResponse(this.prompt).map(r -> {
                if (r.getResult() == null || r.getResult().getOutput() == null || r.getResult().getOutput().getText() == null) {
                    return "";
                }
                return r.getResult().getOutput().getText();
            }).filter(StringUtils::hasLength);
        }
    }

    public static class DefaultCallPromptResponseSpec
    implements ChatClient.CallPromptResponseSpec {
        private final ChatModel chatModel;
        private final Prompt prompt;

        public DefaultCallPromptResponseSpec(ChatModel chatModel, Prompt prompt) {
            Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
            Assert.notNull((Object)prompt, (String)"prompt cannot be null");
            this.chatModel = chatModel;
            this.prompt = prompt;
        }

        @Override
        public String content() {
            return this.doGetChatResponse(this.prompt).getResult().getOutput().getText();
        }

        @Override
        public List<String> contents() {
            return this.doGetChatResponse(this.prompt).getResults().stream().map(r -> r.getOutput().getText()).toList();
        }

        @Override
        public ChatResponse chatResponse() {
            return this.doGetChatResponse(this.prompt);
        }

        private ChatResponse doGetChatResponse(Prompt prompt) {
            return this.chatModel.call(prompt);
        }
    }

    public static class DefaultStreamResponseSpec
    implements ChatClient.StreamResponseSpec {
        private final DefaultChatClientRequestSpec request;

        public DefaultStreamResponseSpec(DefaultChatClientRequestSpec request) {
            Assert.notNull((Object)request, (String)"request cannot be null");
            this.request = request;
        }

        private Flux<ChatResponse> doGetObservableFluxChatResponse(DefaultChatClientRequestSpec inputRequest) {
            return Flux.deferContextual(contextView -> {
                ChatClientObservationContext observationContext = ChatClientObservationContext.builder().withRequest(inputRequest).withStream(true).build();
                Observation observation = ChatClientObservationDocumentation.AI_CHAT_CLIENT.observation(inputRequest.getCustomObservationConvention(), DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION, () -> observationContext, inputRequest.getObservationRegistry());
                observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
                AdvisedRequest initialAdvisedRequest = DefaultChatClient.toAdvisedRequest(inputRequest, null);
                Flux<AdvisedResponse> stream = inputRequest.aroundAdvisorChainBuilder.build().nextAroundStream(initialAdvisedRequest);
                return stream.map(AdvisedResponse::response).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            });
        }

        @Override
        public Flux<ChatResponse> chatResponse() {
            return this.doGetObservableFluxChatResponse(this.request);
        }

        @Override
        public Flux<String> content() {
            return this.doGetObservableFluxChatResponse(this.request).map(r -> {
                if (r.getResult() == null || r.getResult().getOutput() == null || r.getResult().getOutput().getText() == null) {
                    return "";
                }
                return r.getResult().getOutput().getText();
            }).filter(StringUtils::hasLength);
        }
    }

    public static class DefaultCallResponseSpec
    implements ChatClient.CallResponseSpec {
        private final DefaultChatClientRequestSpec request;

        public DefaultCallResponseSpec(DefaultChatClientRequestSpec request) {
            Assert.notNull((Object)request, (String)"request cannot be null");
            this.request = request;
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(Class<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doResponseEntity(new BeanOutputConverter<T>(type));
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doResponseEntity(new BeanOutputConverter<T>(type));
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(StructuredOutputConverter<T> structuredOutputConverter) {
            Assert.notNull(structuredOutputConverter, (String)"structuredOutputConverter cannot be null");
            return this.doResponseEntity(structuredOutputConverter);
        }

        protected <T> ResponseEntity<ChatResponse, T> doResponseEntity(StructuredOutputConverter<T> outputConverter) {
            Assert.notNull(outputConverter, (String)"structuredOutputConverter cannot be null");
            ChatResponse chatResponse = this.doGetObservableChatResponse(this.request, outputConverter.getFormat());
            String responseContent = DefaultCallResponseSpec.getContentFromChatResponse(chatResponse);
            if (responseContent == null) {
                return new ResponseEntity<ChatResponse, Object>(chatResponse, null);
            }
            Object entity2 = outputConverter.convert(responseContent);
            return new ResponseEntity<ChatResponse, Object>(chatResponse, entity2);
        }

        @Override
        @Nullable
        public <T> T entity(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doSingleWithBeanOutputConverter(new BeanOutputConverter<T>(type));
        }

        @Override
        @Nullable
        public <T> T entity(StructuredOutputConverter<T> structuredOutputConverter) {
            Assert.notNull(structuredOutputConverter, (String)"structuredOutputConverter cannot be null");
            return this.doSingleWithBeanOutputConverter(structuredOutputConverter);
        }

        @Override
        @Nullable
        public <T> T entity(Class<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            BeanOutputConverter<T> outputConverter = new BeanOutputConverter<T>(type);
            return this.doSingleWithBeanOutputConverter(outputConverter);
        }

        @Nullable
        private <T> T doSingleWithBeanOutputConverter(StructuredOutputConverter<T> outputConverter) {
            ChatResponse chatResponse = this.doGetObservableChatResponse(this.request, outputConverter.getFormat());
            String stringResponse = DefaultCallResponseSpec.getContentFromChatResponse(chatResponse);
            if (stringResponse == null) {
                return null;
            }
            return (T)outputConverter.convert(stringResponse);
        }

        @Nullable
        private ChatResponse doGetChatResponse() {
            return this.doGetObservableChatResponse(this.request, null);
        }

        @Nullable
        private ChatResponse doGetObservableChatResponse(DefaultChatClientRequestSpec inputRequest, @Nullable String formatParam) {
            ChatClientObservationContext observationContext = ChatClientObservationContext.builder().withRequest(inputRequest).withFormat(formatParam).withStream(false).build();
            Observation observation = ChatClientObservationDocumentation.AI_CHAT_CLIENT.observation(inputRequest.getCustomObservationConvention(), DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION, () -> observationContext, inputRequest.getObservationRegistry());
            return (ChatResponse)observation.observe(() -> this.doGetChatResponse(inputRequest, formatParam, observation));
        }

        private ChatResponse doGetChatResponse(DefaultChatClientRequestSpec inputRequestSpec, @Nullable String formatParam, Observation parentObservation) {
            AdvisedRequest advisedRequest = DefaultChatClient.toAdvisedRequest(inputRequestSpec, formatParam);
            AdvisedResponse advisedResponse = inputRequestSpec.aroundAdvisorChainBuilder.build().nextAroundCall(advisedRequest);
            return advisedResponse.response();
        }

        @Nullable
        private static String getContentFromChatResponse(@Nullable ChatResponse chatResponse) {
            return Optional.ofNullable(chatResponse).map(ChatResponse::getResult).map(Generation::getOutput).map(AbstractMessage::getText).orElse(null);
        }

        @Override
        @Nullable
        public ChatResponse chatResponse() {
            return this.doGetChatResponse();
        }

        @Override
        @Nullable
        public String content() {
            ChatResponse chatResponse = this.doGetChatResponse();
            return DefaultCallResponseSpec.getContentFromChatResponse(chatResponse);
        }
    }

    public static class DefaultAdvisorSpec
    implements ChatClient.AdvisorSpec {
        private final List<Advisor> advisors = new ArrayList<Advisor>();
        private final Map<String, Object> params = new HashMap<String, Object>();

        @Override
        public ChatClient.AdvisorSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec advisors(Advisor ... advisors) {
            Assert.notNull((Object)advisors, (String)"advisors cannot be null");
            Assert.noNullElements((Object[])advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(List.of(advisors));
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec advisors(List<Advisor> advisors) {
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(advisors);
            return this;
        }

        public List<Advisor> getAdvisors() {
            return this.advisors;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }
    }

    public static class DefaultPromptSystemSpec
    implements ChatClient.PromptSystemSpec {
        private final Map<String, Object> params = new HashMap<String, Object>();
        @Nullable
        private String text;

        @Override
        public ChatClient.PromptSystemSpec text(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.text = text;
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec text(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.text(text.getContentAsString(charset));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec text(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            this.text(text, Charset.defaultCharset());
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Nullable
        protected String text() {
            return this.text;
        }

        protected Map<String, Object> params() {
            return this.params;
        }
    }

    public static class DefaultPromptUserSpec
    implements ChatClient.PromptUserSpec {
        private final Map<String, Object> params = new HashMap<String, Object>();
        private final List<Media> media = new ArrayList<Media>();
        @Nullable
        private String text;

        @Override
        public ChatClient.PromptUserSpec media(Media ... media) {
            Assert.notNull((Object)media, (String)"media cannot be null");
            Assert.noNullElements((Object[])media, (String)"media cannot contain null elements");
            this.media.addAll(Arrays.asList(media));
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec media(MimeType mimeType, URL url) {
            Assert.notNull((Object)mimeType, (String)"mimeType cannot be null");
            Assert.notNull((Object)url, (String)"url cannot be null");
            this.media.add(Media.builder().mimeType(mimeType).data(url).build());
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec media(MimeType mimeType, Resource resource) {
            Assert.notNull((Object)mimeType, (String)"mimeType cannot be null");
            Assert.notNull((Object)resource, (String)"resource cannot be null");
            this.media.add(Media.builder().mimeType(mimeType).data(resource).build());
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.text = text;
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.text(text.getContentAsString(charset));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            this.text(text, Charset.defaultCharset());
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Nullable
        protected String text() {
            return this.text;
        }

        protected Map<String, Object> params() {
            return this.params;
        }

        protected List<Media> media() {
            return this.media;
        }
    }
}

