/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationContext;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationDocumentation;
import org.springframework.ai.observation.conventions.AiOperationType;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.observation.conventions.SpringAiKind;
import org.springframework.ai.util.ParsingUtils;
import org.springframework.lang.Nullable;

public class DefaultAdvisorObservationConvention
implements AdvisorObservationConvention {
    public static final String DEFAULT_NAME = "spring.ai.advisor";
    private final String name;

    public DefaultAdvisorObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultAdvisorObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getContextualName(AdvisorObservationContext context) {
        return ParsingUtils.reConcatenateCamelCase(context.getAdvisorName(), "_").replace("_around_advisor", "").replace("_advisor", "");
    }

    public KeyValues getLowCardinalityKeyValues(AdvisorObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.springAiKind(), this.advisorType(context), this.advisorName(context)});
    }

    protected KeyValue aiOperationType(AdvisorObservationContext context) {
        return KeyValue.of((KeyName)AdvisorObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)AiOperationType.FRAMEWORK.value());
    }

    protected KeyValue aiProvider(AdvisorObservationContext context) {
        return KeyValue.of((KeyName)AdvisorObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)AiProvider.SPRING_AI.value());
    }

    protected KeyValue advisorType(AdvisorObservationContext context) {
        return KeyValue.of((KeyName)AdvisorObservationDocumentation.LowCardinalityKeyNames.ADVISOR_TYPE, (String)context.getAdvisorType().name());
    }

    protected KeyValue springAiKind() {
        return KeyValue.of((KeyName)AdvisorObservationDocumentation.LowCardinalityKeyNames.SPRING_AI_KIND, (String)SpringAiKind.ADVISOR.value());
    }

    protected KeyValue advisorName(AdvisorObservationContext context) {
        return KeyValue.of((KeyName)AdvisorObservationDocumentation.LowCardinalityKeyNames.ADVISOR_NAME, (String)context.getAdvisorName());
    }

    public KeyValues getHighCardinalityKeyValues(AdvisorObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.advisorOrder(context)});
    }

    protected KeyValue advisorOrder(AdvisorObservationContext context) {
        return KeyValue.of((KeyName)AdvisorObservationDocumentation.HighCardinalityKeyNames.ADVISOR_ORDER, (String)("" + context.getOrder()));
    }
}

