/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.observation;

import java.util.Collection;
import java.util.List;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.Content;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class ChatModelObservationContentProcessor {
    private ChatModelObservationContentProcessor() {
    }

    public static List<String> prompt(ChatModelObservationContext context) {
        if (CollectionUtils.isEmpty((Collection)((Prompt)context.getRequest()).getInstructions())) {
            return List.of();
        }
        return ((Prompt)context.getRequest()).getInstructions().stream().map(Content::getText).toList();
    }

    public static List<String> completion(ChatModelObservationContext context) {
        if (context == null || context.getResponse() == null || ((ChatResponse)context.getResponse()).getResults() == null || CollectionUtils.isEmpty(((ChatResponse)context.getResponse()).getResults())) {
            return List.of();
        }
        if (!StringUtils.hasText((String)((ChatResponse)context.getResponse()).getResult().getOutput().getText())) {
            return List.of();
        }
        return ((ChatResponse)context.getResponse()).getResults().stream().filter(generation -> generation.getOutput() != null && StringUtils.hasText((String)generation.getOutput().getText())).map(generation -> generation.getOutput().getText()).toList();
    }
}

