/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import java.util.Objects;
import org.springframework.ai.embedding.EmbeddingResultMetadata;
import org.springframework.ai.model.ModelResult;

public class Embedding
implements ModelResult<float[]> {
    private float[] embedding;
    private Integer index;
    private EmbeddingResultMetadata metadata;

    public Embedding(float[] embedding, Integer index) {
        this(embedding, index, EmbeddingResultMetadata.EMPTY);
    }

    public Embedding(float[] embedding, Integer index, EmbeddingResultMetadata metadata) {
        this.embedding = embedding;
        this.index = index;
        this.metadata = metadata;
    }

    @Override
    public float[] getOutput() {
        return this.embedding;
    }

    public Integer getIndex() {
        return this.index;
    }

    @Override
    public EmbeddingResultMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Embedding other = (Embedding)o;
        return Objects.equals(this.embedding, other.embedding) && Objects.equals(this.index, other.index);
    }

    public int hashCode() {
        return Objects.hash(this.embedding, this.index);
    }

    public String toString() {
        String message = this.embedding.length == 0 ? "<empty>" : "<has data>";
        return "Embedding{embedding=" + message + ", index=" + this.index + "}";
    }
}

