/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import org.springframework.ai.model.ResultMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class EmbeddingResultMetadata
implements ResultMetadata {
    public static EmbeddingResultMetadata EMPTY = new EmbeddingResultMetadata();
    private final ModalityType modalityType;
    private final String documentId;
    private final MimeType mimeType;
    private final Object documentData;

    public EmbeddingResultMetadata() {
        this("", ModalityType.TEXT, MimeTypeUtils.TEXT_PLAIN, null);
    }

    public EmbeddingResultMetadata(String documentId, ModalityType modalityType, MimeType mimeType, Object documentData) {
        Assert.notNull((Object)((Object)modalityType), (String)"ModalityType must not be null");
        Assert.notNull((Object)mimeType, (String)"MimeType must not be null");
        this.documentId = documentId;
        this.modalityType = modalityType;
        this.mimeType = mimeType;
        this.documentData = documentData;
    }

    public ModalityType getModalityType() {
        return this.modalityType;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public Object getDocumentData() {
        return this.documentData;
    }

    public static enum ModalityType {
        TEXT,
        IMAGE,
        AUDIO,
        VIDEO;

    }

    public static class ModalityUtils {
        private static MimeType TEXT_MIME_TYPE = MimeTypeUtils.parseMimeType((String)"text/*");
        private static MimeType IMAGE_MIME_TYPE = MimeTypeUtils.parseMimeType((String)"image/*");
        private static MimeType VIDEO_MIME_TYPE = MimeTypeUtils.parseMimeType((String)"video/*");
        private static MimeType AUDIO_MIME_TYPE = MimeTypeUtils.parseMimeType((String)"audio/*");

        public static ModalityType getModalityType(MimeType mimeType) {
            if (mimeType == null) {
                return ModalityType.TEXT;
            }
            if (mimeType.isCompatibleWith(IMAGE_MIME_TYPE)) {
                return ModalityType.IMAGE;
            }
            if (mimeType.isCompatibleWith(AUDIO_MIME_TYPE)) {
                return ModalityType.AUDIO;
            }
            if (mimeType.isCompatibleWith(VIDEO_MIME_TYPE)) {
                return ModalityType.VIDEO;
            }
            if (mimeType.isCompatibleWith(TEXT_MIME_TYPE)) {
                return ModalityType.TEXT;
            }
            throw new IllegalArgumentException("Unsupported MimeType: " + String.valueOf(mimeType));
        }
    }
}

