/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.DefaultCommonCallbackInvokingSpec;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionInvokingFunctionCallback;
import org.springframework.ai.model.function.MethodInvokingFunctionCallback;
import org.springframework.ai.util.ParsingUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public class DefaultFunctionCallbackBuilder
implements FunctionCallback.Builder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFunctionCallbackBuilder.class);

    @Override
    public <I, O> FunctionCallback.FunctionInvokingSpec<I, O> function(String name, Function<I, O> function) {
        return new DefaultFunctionInvokingSpec<I, O>(name, function);
    }

    @Override
    public <I, O> FunctionCallback.FunctionInvokingSpec<I, O> function(String name, BiFunction<I, ToolContext, O> biFunction) {
        return new DefaultFunctionInvokingSpec<I, O>(name, biFunction);
    }

    @Override
    public <O> FunctionCallback.FunctionInvokingSpec<Void, O> function(String name, Supplier<O> supplier) {
        Function<Void, Object> function = input -> supplier.get();
        return new DefaultFunctionInvokingSpec<Void, Object>(name, function).inputType(Void.class);
    }

    @Override
    public <I> FunctionCallback.FunctionInvokingSpec<I, Void> function(String name, Consumer<I> consumer) {
        Function<Object, Void> function = input -> {
            consumer.accept(input);
            return null;
        };
        return new DefaultFunctionInvokingSpec<Object, Void>(name, function);
    }

    @Override
    public FunctionCallback.MethodInvokingSpec method(String methodName, Class<?> ... argumentTypes) {
        return new DefaultMethodInvokingSpec(methodName, argumentTypes);
    }

    private String generateDescription(String fromName) {
        String generatedDescription = ParsingUtils.reConcatenateCamelCase(fromName, " ");
        logger.info("Description is not set! A best effort attempt to generate a description:'{}' from the:'{}'", (Object)generatedDescription, (Object)fromName);
        logger.info("It is recommended to set the Description explicitly! Use the 'description()' method!");
        return generatedDescription;
    }

    final class DefaultFunctionInvokingSpec<I, O>
    extends DefaultCommonCallbackInvokingSpec<FunctionCallback.FunctionInvokingSpec<I, O>>
    implements FunctionCallback.FunctionInvokingSpec<I, O> {
        private final String name;
        private Type inputType;
        private final BiFunction<I, ToolContext, O> biFunction;
        private final Function<I, O> function;

        private DefaultFunctionInvokingSpec(String name, BiFunction<I, ToolContext, O> biFunction) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            Assert.notNull(biFunction, (String)"BiFunction must not be null");
            this.name = name;
            this.biFunction = biFunction;
            this.function = null;
        }

        private DefaultFunctionInvokingSpec(String name, Function<I, O> function) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            Assert.notNull(function, (String)"Function must not be null");
            this.name = name;
            this.biFunction = null;
            this.function = function;
        }

        @Override
        public FunctionCallback.FunctionInvokingSpec<I, O> inputType(Class<?> inputType) {
            Assert.notNull(inputType, (String)"InputType must not be null");
            this.inputType = inputType;
            return this;
        }

        @Override
        public FunctionCallback.FunctionInvokingSpec<I, O> inputType(ParameterizedTypeReference<?> inputType) {
            Assert.notNull(inputType, (String)"InputType must not be null");
            this.inputType = inputType.getType();
            return this;
        }

        @Override
        public FunctionCallback build() {
            Assert.notNull((Object)this.getObjectMapper(), (String)"ObjectMapper must not be null");
            Assert.hasText((String)this.name, (String)"Name must not be empty");
            Assert.notNull(this.getResponseConverter(), (String)"ResponseConverter must not be null");
            Assert.notNull((Object)this.inputType, (String)"InputType must not be null");
            if (this.getInputTypeSchema() == null) {
                boolean upperCaseTypeValues = this.schemaType == FunctionCallback.SchemaType.OPEN_API_SCHEMA;
                this.inputTypeSchema = ModelOptionsUtils.getJsonSchema(this.inputType, upperCaseTypeValues);
            }
            BiFunction<Object, ToolContext, Object> finalBiFunction = this.biFunction != null ? this.biFunction : (request, context) -> this.function.apply(request);
            return new FunctionInvokingFunctionCallback<I, Object>(this.name, this.getDescriptionExt(), this.getInputTypeSchema(), this.inputType, this.getResponseConverter(), this.getObjectMapper(), finalBiFunction);
        }

        private String getDescriptionExt() {
            if (StringUtils.hasText((String)this.getDescription())) {
                return this.getDescription();
            }
            return DefaultFunctionCallbackBuilder.this.generateDescription(this.name);
        }
    }

    final class DefaultMethodInvokingSpec
    extends DefaultCommonCallbackInvokingSpec<FunctionCallback.MethodInvokingSpec>
    implements FunctionCallback.MethodInvokingSpec {
        private String name;
        private final String methodName;
        private Class<?> targetClass;
        private Object targetObject;
        private final Class<?>[] argumentTypes;

        private DefaultMethodInvokingSpec(String methodName, Class<?> ... argumentTypes) {
            Assert.hasText((String)methodName, (String)"Method name must not be null");
            Assert.notNull(argumentTypes, (String)"Argument types must not be null");
            this.methodName = methodName;
            this.argumentTypes = argumentTypes;
        }

        @Override
        public FunctionCallback.MethodInvokingSpec name(String name) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            this.name = name;
            return this;
        }

        @Override
        public FunctionCallback.MethodInvokingSpec targetClass(Class<?> targetClass) {
            Assert.notNull(targetClass, (String)"Target class must not be null");
            this.targetClass = targetClass;
            return this;
        }

        @Override
        public FunctionCallback.MethodInvokingSpec targetObject(Object methodObject) {
            Assert.notNull((Object)methodObject, (String)"Method object must not be null");
            this.targetObject = methodObject;
            this.targetClass = methodObject.getClass();
            return this;
        }

        @Override
        public FunctionCallback build() {
            Assert.isTrue((this.targetClass != null || this.targetObject != null ? 1 : 0) != 0, (String)"Target class or object must not be null");
            Method method = ReflectionUtils.findMethod(this.targetClass, (String)this.methodName, (Class[])this.argumentTypes);
            Assert.notNull((Object)method, (String)("Method: '" + this.methodName + "' with arguments:" + Arrays.toString(this.argumentTypes) + " not found!"));
            return new MethodInvokingFunctionCallback(this.targetObject, method, this.getDescriptionExt(), this.getObjectMapper(), this.name, this.getResponseConverter());
        }

        private String getDescriptionExt() {
            if (StringUtils.hasText((String)this.getDescription())) {
                return this.getDescription();
            }
            return DefaultFunctionCallbackBuilder.this.generateDescription(StringUtils.hasText((String)this.name) ? this.name : this.methodName);
        }
    }
}

