/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.tool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.execution.DefaultToolExecutionExceptionProcessor;
import org.springframework.ai.tool.execution.ToolExecutionException;
import org.springframework.ai.tool.execution.ToolExecutionExceptionProcessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Deprecated
public class LegacyToolCallingManager
implements ToolCallingManager {
    @Nullable
    private final FunctionCallbackResolver functionCallbackResolver;
    private final Map<String, FunctionCallback> functionCallbacks = new HashMap<String, FunctionCallback>();
    private final ToolExecutionExceptionProcessor toolExecutionExceptionProcessor = DefaultToolExecutionExceptionProcessor.builder().build();

    public LegacyToolCallingManager(@Nullable FunctionCallbackResolver functionCallbackResolver, @Nullable List<FunctionCallback> functionCallbacks) {
        this.functionCallbackResolver = functionCallbackResolver;
        if (functionCallbacks != null) {
            functionCallbacks.forEach(toolCallback -> this.functionCallbacks.put(toolCallback.getName(), (FunctionCallback)toolCallback));
        }
    }

    @Override
    public List<ToolDefinition> resolveToolDefinitions(ToolCallingChatOptions chatOptions) {
        Assert.notNull((Object)chatOptions, (String)"chatOptions cannot be null");
        ArrayList<FunctionCallback> toolCallbacks = new ArrayList<FunctionCallback>(chatOptions.getToolCallbacks());
        for (String toolName : chatOptions.getToolNames()) {
            if (chatOptions.getToolCallbacks().stream().anyMatch(tool -> tool.getName().equals(toolName))) continue;
            FunctionCallback toolCallback = this.resolveFunctionCallback(toolName);
            if (toolCallback == null) {
                throw new IllegalStateException("No ToolCallback found for tool name: " + toolName);
            }
            toolCallbacks.add(toolCallback);
        }
        return toolCallbacks.stream().map(functionCallback -> {
            if (functionCallback instanceof ToolCallback) {
                ToolCallback toolCallback = (ToolCallback)functionCallback;
                return toolCallback.getToolDefinition();
            }
            return ToolDefinition.builder().name(functionCallback.getName()).description(functionCallback.getDescription()).inputSchema(functionCallback.getInputTypeSchema()).build();
        }).toList();
    }

    @Nullable
    private FunctionCallback resolveFunctionCallback(String toolName) {
        Assert.hasText((String)toolName, (String)"toolName cannot be null or empty");
        if (this.functionCallbacks.get(toolName) != null) {
            return this.functionCallbacks.get(toolName);
        }
        return this.functionCallbackResolver != null ? this.functionCallbackResolver.resolve(toolName) : null;
    }

    @Override
    public ToolExecutionResult executeToolCalls(Prompt prompt, ChatResponse chatResponse) {
        Assert.notNull((Object)prompt, (String)"prompt cannot be null");
        Assert.notNull((Object)chatResponse, (String)"chatResponse cannot be null");
        Optional<Generation> toolCallGeneration = chatResponse.getResults().stream().filter(g -> !CollectionUtils.isEmpty(g.getOutput().getToolCalls())).findFirst();
        if (toolCallGeneration.isEmpty()) {
            throw new IllegalStateException("No tool call requested by the chat model");
        }
        AssistantMessage assistantMessage = toolCallGeneration.get().getOutput();
        ToolContext toolContext = LegacyToolCallingManager.buildToolContext(prompt, assistantMessage);
        ToolResponseMessage toolMessageResponse = this.executeToolCall(prompt, assistantMessage, toolContext);
        List<Message> conversationHistory = this.buildConversationHistoryAfterToolExecution((List<Message>)prompt.getInstructions(), assistantMessage, toolMessageResponse);
        return ToolExecutionResult.builder().conversationHistory(conversationHistory).returnDirect(false).build();
    }

    private static ToolContext buildToolContext(Prompt prompt, AssistantMessage assistantMessage) {
        FunctionCallingOptions functionOptions;
        Map<String, Object> toolContextMap = Map.of();
        ChatOptions chatOptions = prompt.getOptions();
        if (chatOptions instanceof FunctionCallingOptions && !CollectionUtils.isEmpty((functionOptions = (FunctionCallingOptions)chatOptions).getToolContext())) {
            toolContextMap = new HashMap<String, Object>(functionOptions.getToolContext());
            ArrayList<AssistantMessage> messageHistory = new ArrayList<AssistantMessage>((Collection<AssistantMessage>)prompt.copy().getInstructions());
            messageHistory.add(new AssistantMessage(assistantMessage.getText(), assistantMessage.getMetadata(), assistantMessage.getToolCalls()));
            toolContextMap.put("TOOL_CALL_HISTORY", LegacyToolCallingManager.buildConversationHistoryBeforeToolExecution(prompt, assistantMessage));
        }
        return new ToolContext(toolContextMap);
    }

    private static List<Message> buildConversationHistoryBeforeToolExecution(Prompt prompt, AssistantMessage assistantMessage) {
        ArrayList<Message> messageHistory = new ArrayList<Message>((Collection<Message>)prompt.copy().getInstructions());
        messageHistory.add(new AssistantMessage(assistantMessage.getText(), assistantMessage.getMetadata(), assistantMessage.getToolCalls()));
        return messageHistory;
    }

    private ToolResponseMessage executeToolCall(Prompt prompt, AssistantMessage assistantMessage, ToolContext toolContext) {
        List<Object> toolCallbacks = List.of();
        ChatOptions chatOptions = prompt.getOptions();
        if (chatOptions instanceof ToolCallingChatOptions) {
            ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
            toolCallbacks = toolCallingChatOptions.getToolCallbacks();
        } else {
            chatOptions = prompt.getOptions();
            if (chatOptions instanceof FunctionCallingOptions) {
                FunctionCallingOptions functionOptions = (FunctionCallingOptions)chatOptions;
                toolCallbacks = functionOptions.getFunctionCallbacks();
            }
        }
        ArrayList<ToolResponseMessage.ToolResponse> toolResponses = new ArrayList<ToolResponseMessage.ToolResponse>();
        for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
            String toolResult;
            String toolName = toolCall.name();
            String toolInputArguments = toolCall.arguments();
            FunctionCallback toolCallback = toolCallbacks.stream().filter(tool -> toolName.equals(tool.getName())).findFirst().orElseGet(() -> this.resolveFunctionCallback(toolName));
            if (toolCallback == null) {
                throw new IllegalStateException("No ToolCallback found for tool name: " + toolName);
            }
            try {
                toolResult = toolCallback.call(toolInputArguments, toolContext);
            }
            catch (ToolExecutionException ex) {
                toolResult = this.toolExecutionExceptionProcessor.process(ex);
            }
            toolResponses.add(new ToolResponseMessage.ToolResponse(toolCall.id(), toolName, toolResult));
        }
        return new ToolResponseMessage(toolResponses, Map.of());
    }

    private List<Message> buildConversationHistoryAfterToolExecution(List<Message> previousMessages, AssistantMessage assistantMessage, ToolResponseMessage toolResponseMessage) {
        ArrayList<Message> messages = new ArrayList<Message>(previousMessages);
        messages.add(assistantMessage);
        messages.add(toolResponseMessage);
        return messages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FunctionCallbackResolver functionCallbackResolver;
        private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();

        private Builder() {
        }

        public Builder functionCallbackResolver(FunctionCallbackResolver functionCallbackResolver) {
            this.functionCallbackResolver = functionCallbackResolver;
            return this;
        }

        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.functionCallbacks = functionCallbacks;
            return this;
        }

        public LegacyToolCallingManager build() {
            return new LegacyToolCallingManager(this.functionCallbackResolver, this.functionCallbacks);
        }
    }
}

