/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.rag.preretrieval.query.transformation;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.rag.Query;
import org.springframework.ai.rag.preretrieval.query.transformation.QueryTransformer;
import org.springframework.ai.util.PromptAssert;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CompressionQueryTransformer
implements QueryTransformer {
    private static final Logger logger = LoggerFactory.getLogger(CompressionQueryTransformer.class);
    private static final PromptTemplate DEFAULT_PROMPT_TEMPLATE = new PromptTemplate("Given the following conversation history and a follow-up query, your task is to synthesize\na concise, standalone query that incorporates the context from the history.\nEnsure the standalone query is clear, specific, and maintains the user's intent.\n\nConversation history:\n{history}\n\nFollow-up query:\n{query}\n\nStandalone query:\n");
    private final ChatClient chatClient;
    private final PromptTemplate promptTemplate;

    public CompressionQueryTransformer(ChatClient.Builder chatClientBuilder, @Nullable PromptTemplate promptTemplate) {
        Assert.notNull((Object)chatClientBuilder, (String)"chatClientBuilder cannot be null");
        this.chatClient = chatClientBuilder.build();
        this.promptTemplate = promptTemplate != null ? promptTemplate : DEFAULT_PROMPT_TEMPLATE;
        PromptAssert.templateHasRequiredPlaceholders(this.promptTemplate, "history", "query");
    }

    @Override
    public Query transform(Query query) {
        Assert.notNull((Object)query, (String)"query cannot be null");
        logger.debug("Compressing conversation history and follow-up query into a standalone query");
        String compressedQueryText = this.chatClient.prompt().user(user -> user.text(this.promptTemplate.getTemplate()).param("history", this.formatConversationHistory(query.history())).param("query", query.text())).options(ChatOptions.builder().temperature(0.0).build()).call().content();
        if (!StringUtils.hasText((String)compressedQueryText)) {
            logger.warn("Query compression result is null/empty. Returning the input query unchanged.");
            return query;
        }
        return query.mutate().text(compressedQueryText).build();
    }

    private String formatConversationHistory(List<Message> history) {
        if (history.isEmpty()) {
            return "";
        }
        return history.stream().filter(message -> message.getMessageType().equals((Object)MessageType.USER) || message.getMessageType().equals((Object)MessageType.ASSISTANT)).map(message -> "%s: %s".formatted(new Object[]{message.getMessageType(), message.getText()})).collect(Collectors.joining("\n"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ChatClient.Builder chatClientBuilder;
        @Nullable
        private PromptTemplate promptTemplate;

        private Builder() {
        }

        public Builder chatClientBuilder(ChatClient.Builder chatClientBuilder) {
            this.chatClientBuilder = chatClientBuilder;
            return this;
        }

        public Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public CompressionQueryTransformer build() {
            return new CompressionQueryTransformer(this.chatClientBuilder, this.promptTemplate);
        }
    }
}

