/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.method;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.metadata.ToolMetadata;
import org.springframework.ai.tool.method.MethodToolCallback;
import org.springframework.ai.tool.util.ToolUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MethodToolCallbackProvider
implements ToolCallbackProvider {
    private static final Logger logger = LoggerFactory.getLogger(MethodToolCallbackProvider.class);
    private final List<Object> toolObjects;

    private MethodToolCallbackProvider(List<Object> toolObjects) {
        Assert.notNull(toolObjects, (String)"toolObjects cannot be null");
        Assert.noNullElements(toolObjects, (String)"toolObjects cannot contain null elements");
        this.toolObjects = toolObjects;
    }

    public ToolCallback[] getToolCallbacks() {
        ToolCallback[] toolCallbacks = (ToolCallback[])this.toolObjects.stream().map(toolObject -> (ToolCallback[])Stream.of(ReflectionUtils.getDeclaredMethods(toolObject.getClass())).filter(toolMethod -> toolMethod.isAnnotationPresent(Tool.class)).filter(toolMethod -> !this.isFunctionalType((Method)toolMethod)).map(toolMethod -> MethodToolCallback.builder().toolDefinition(ToolDefinition.from(toolMethod)).toolMetadata(ToolMetadata.from(toolMethod)).toolMethod((Method)toolMethod).toolObject(toolObject).toolCallResultConverter(ToolUtils.getToolCallResultConverter(toolMethod)).build()).toArray(ToolCallback[]::new)).flatMap(Stream::of).toArray(ToolCallback[]::new);
        this.validateToolCallbacks(toolCallbacks);
        return toolCallbacks;
    }

    private boolean isFunctionalType(Method toolMethod) {
        boolean isFunction;
        boolean bl = isFunction = ClassUtils.isAssignable(toolMethod.getReturnType(), Function.class) || ClassUtils.isAssignable(toolMethod.getReturnType(), Supplier.class) || ClassUtils.isAssignable(toolMethod.getReturnType(), Consumer.class);
        if (isFunction) {
            logger.warn("Method {} is annotated with @Tool but returns a functional type. This is not supported and the method will be ignored.", (Object)toolMethod.getName());
        }
        return isFunction;
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List<String> duplicateToolNames = ToolUtils.getDuplicateToolNames(toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s) found in sources: %s".formatted(String.join((CharSequence)", ", duplicateToolNames), this.toolObjects.stream().map(o -> o.getClass().getName()).collect(Collectors.joining(", "))));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Object> toolObjects;

        private Builder() {
        }

        public Builder toolObjects(Object ... toolObjects) {
            Assert.notNull((Object)toolObjects, (String)"toolObjects cannot be null");
            this.toolObjects = Arrays.asList(toolObjects);
            return this;
        }

        public MethodToolCallbackProvider build() {
            return new MethodToolCallbackProvider(this.toolObjects);
        }
    }
}

