/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractVectorStoreBuilder<T extends AbstractVectorStoreBuilder<T>>
implements VectorStore.Builder<T> {
    protected final EmbeddingModel embeddingModel;
    protected ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    @Nullable
    protected VectorStoreObservationConvention customObservationConvention;
    protected BatchingStrategy batchingStrategy = new TokenCountBatchingStrategy();

    public AbstractVectorStoreBuilder(EmbeddingModel embeddingModel) {
        Assert.notNull((Object)embeddingModel, (String)"EmbeddingModel must be configured");
        this.embeddingModel = embeddingModel;
    }

    public EmbeddingModel getEmbeddingModel() {
        return this.embeddingModel;
    }

    public BatchingStrategy getBatchingStrategy() {
        return this.batchingStrategy;
    }

    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    @Nullable
    public VectorStoreObservationConvention getCustomObservationConvention() {
        return this.customObservationConvention;
    }

    protected T self() {
        return (T)this;
    }

    @Override
    public T observationRegistry(ObservationRegistry observationRegistry) {
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.observationRegistry = observationRegistry;
        return this.self();
    }

    @Override
    public T customObservationConvention(@Nullable VectorStoreObservationConvention convention) {
        this.customObservationConvention = convention;
        return this.self();
    }

    @Override
    public T batchingStrategy(BatchingStrategy batchingStrategy) {
        Assert.notNull((Object)batchingStrategy, (String)"BatchingStrategy must not be null");
        this.batchingStrategy = batchingStrategy;
        return this.self();
    }
}

