/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.filter.converter;

import java.util.List;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.filter.FilterHelper;

public abstract class AbstractFilterExpressionConverter
implements FilterExpressionConverter {
    @Override
    public String convertExpression(Filter.Expression expression) {
        return this.convertOperand(expression);
    }

    protected String convertOperand(Filter.Operand operand) {
        StringBuilder context = new StringBuilder();
        this.convertOperand(operand, context);
        return context.toString();
    }

    protected void convertOperand(Filter.Operand operand, StringBuilder context) {
        if (operand instanceof Filter.Group) {
            Filter.Group group = (Filter.Group)operand;
            this.doGroup(group, context);
        } else if (operand instanceof Filter.Key) {
            Filter.Key key = (Filter.Key)operand;
            this.doKey(key, context);
        } else if (operand instanceof Filter.Value) {
            Filter.Value value = (Filter.Value)operand;
            this.doValue(value, context);
        } else if (operand instanceof Filter.Expression) {
            Filter.Expression expression = (Filter.Expression)operand;
            if (expression.type() != Filter.ExpressionType.NOT && expression.type() != Filter.ExpressionType.AND && expression.type() != Filter.ExpressionType.OR && !(expression.right() instanceof Filter.Value)) {
                throw new RuntimeException("Non AND/OR expression must have Value right argument!");
            }
            if (expression.type() == Filter.ExpressionType.NOT) {
                this.doNot(expression, context);
            } else {
                this.doExpression(expression, context);
            }
        }
    }

    protected void doNot(Filter.Expression expression, StringBuilder context) {
        this.convertOperand(FilterHelper.negate(expression), context);
    }

    protected abstract void doExpression(Filter.Expression var1, StringBuilder var2);

    protected abstract void doKey(Filter.Key var1, StringBuilder var2);

    protected void doValue(Filter.Value filterValue, StringBuilder context) {
        Object object = filterValue.value();
        if (object instanceof List) {
            List list = (List)object;
            this.doStartValueRange(filterValue, context);
            int c = 0;
            for (Object v : list) {
                this.doSingleValue(v, context);
                if (c++ >= list.size() - 1) continue;
                this.doAddValueRangeSpitter(filterValue, context);
            }
            this.doEndValueRange(filterValue, context);
        } else {
            this.doSingleValue(filterValue.value(), context);
        }
    }

    protected void doSingleValue(Object value, StringBuilder context) {
        if (value instanceof String) {
            context.append(String.format("\"%s\"", value));
        } else {
            context.append(value);
        }
    }

    protected void doGroup(Filter.Group group, StringBuilder context) {
        this.doStartGroup(group, context);
        this.convertOperand(group.content(), context);
        this.doEndGroup(group, context);
    }

    protected void doStartGroup(Filter.Group group, StringBuilder context) {
    }

    protected void doEndGroup(Filter.Group group, StringBuilder context) {
    }

    protected void doStartValueRange(Filter.Value listValue, StringBuilder context) {
        context.append("[");
    }

    protected void doEndValueRange(Filter.Value listValue, StringBuilder context) {
        context.append("]");
    }

    protected void doAddValueRangeSpitter(Filter.Value listValue, StringBuilder context) {
        context.append(",");
    }

    protected boolean hasOuterQuotes(String str) {
        return (str = str.trim()).startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'");
    }

    protected String removeOuterQuotes(String in) {
        return in.substring(1, in.length() - 1);
    }
}

