/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.ai.observation.conventions.SpringAiKind;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationDocumentation;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultVectorStoreObservationConvention
implements VectorStoreObservationConvention {
    public static final String DEFAULT_NAME = "db.vector.client.operation";
    private final String name;

    public DefaultVectorStoreObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultVectorStoreObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getContextualName(VectorStoreObservationContext context) {
        return "%s %s".formatted(context.getDatabaseSystem(), context.getOperationName());
    }

    public KeyValues getLowCardinalityKeyValues(VectorStoreObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.springAiKind(), this.dbSystem(context), this.dbOperationName(context)});
    }

    protected KeyValue springAiKind() {
        return KeyValue.of((KeyName)VectorStoreObservationDocumentation.LowCardinalityKeyNames.SPRING_AI_KIND, (String)SpringAiKind.VECTOR_STORE.value());
    }

    protected KeyValue dbSystem(VectorStoreObservationContext context) {
        return KeyValue.of((KeyName)VectorStoreObservationDocumentation.LowCardinalityKeyNames.DB_SYSTEM, (String)context.getDatabaseSystem());
    }

    protected KeyValue dbOperationName(VectorStoreObservationContext context) {
        return KeyValue.of((KeyName)VectorStoreObservationDocumentation.LowCardinalityKeyNames.DB_OPERATION_NAME, (String)context.getOperationName());
    }

    public KeyValues getHighCardinalityKeyValues(VectorStoreObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.collectionName(keyValues, context);
        keyValues = this.dimensions(keyValues, context);
        keyValues = this.fieldName(keyValues, context);
        keyValues = this.metadataFilter(keyValues, context);
        keyValues = this.namespace(keyValues, context);
        keyValues = this.queryContent(keyValues, context);
        keyValues = this.similarityMetric(keyValues, context);
        keyValues = this.similarityThreshold(keyValues, context);
        keyValues = this.topK(keyValues, context);
        return keyValues;
    }

    protected KeyValues collectionName(KeyValues keyValues, VectorStoreObservationContext context) {
        if (StringUtils.hasText((String)context.getCollectionName())) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_COLLECTION_NAME.asString(), context.getCollectionName());
        }
        return keyValues;
    }

    protected KeyValues dimensions(KeyValues keyValues, VectorStoreObservationContext context) {
        if (context.getDimensions() != null && context.getDimensions() > 0) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_VECTOR_DIMENSION_COUNT.asString(), "" + context.getDimensions());
        }
        return keyValues;
    }

    protected KeyValues fieldName(KeyValues keyValues, VectorStoreObservationContext context) {
        if (StringUtils.hasText((String)context.getFieldName())) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_VECTOR_FIELD_NAME.asString(), context.getFieldName());
        }
        return keyValues;
    }

    protected KeyValues metadataFilter(KeyValues keyValues, VectorStoreObservationContext context) {
        if (context.getQueryRequest() != null && context.getQueryRequest().getFilterExpression() != null) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_VECTOR_QUERY_FILTER.asString(), context.getQueryRequest().getFilterExpression().toString());
        }
        return keyValues;
    }

    protected KeyValues namespace(KeyValues keyValues, VectorStoreObservationContext context) {
        if (StringUtils.hasText((String)context.getNamespace())) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_NAMESPACE.asString(), context.getNamespace());
        }
        return keyValues;
    }

    protected KeyValues queryContent(KeyValues keyValues, VectorStoreObservationContext context) {
        if (context.getQueryRequest() != null && StringUtils.hasText((String)context.getQueryRequest().getQuery())) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_VECTOR_QUERY_CONTENT.asString(), context.getQueryRequest().getQuery());
        }
        return keyValues;
    }

    protected KeyValues similarityMetric(KeyValues keyValues, VectorStoreObservationContext context) {
        if (StringUtils.hasText((String)context.getSimilarityMetric())) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_SEARCH_SIMILARITY_METRIC.asString(), context.getSimilarityMetric());
        }
        return keyValues;
    }

    protected KeyValues similarityThreshold(KeyValues keyValues, VectorStoreObservationContext context) {
        if (context.getQueryRequest() != null && context.getQueryRequest().getSimilarityThreshold() >= 0.0) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_VECTOR_QUERY_SIMILARITY_THRESHOLD.asString(), String.valueOf(context.getQueryRequest().getSimilarityThreshold()));
        }
        return keyValues;
    }

    protected KeyValues topK(KeyValues keyValues, VectorStoreObservationContext context) {
        if (context.getQueryRequest() != null && context.getQueryRequest().getTopK() > 0) {
            return keyValues.and(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_VECTOR_QUERY_TOP_K.asString(), "" + context.getQueryRequest().getTopK());
        }
        return keyValues;
    }
}

