/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import java.util.List;
import org.springframework.ai.observation.tracing.TracingHelper;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContentProcessor;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationDocumentation;
import org.springframework.util.CollectionUtils;

public class VectorStoreQueryResponseObservationFilter
implements ObservationFilter {
    public Observation.Context map(Observation.Context context) {
        if (!(context instanceof VectorStoreObservationContext)) {
            return context;
        }
        VectorStoreObservationContext observationContext = (VectorStoreObservationContext)context;
        List<String> documents = VectorStoreObservationContentProcessor.documents(observationContext);
        if (!CollectionUtils.isEmpty(documents)) {
            observationContext.addHighCardinalityKeyValue(VectorStoreObservationDocumentation.HighCardinalityKeyNames.DB_VECTOR_QUERY_RESPONSE_DOCUMENTS.withValue(TracingHelper.concatenateStrings(documents)));
        }
        return observationContext;
    }
}

